%define privuser  schatd
%define privgroup schatd
%define privpath  /var/empty

Name: schat
Version: 2.4.0
Release: alt1.cf35e54

Summary: IMPOMEZIA Simple Chat

License: GPLv3+
Group: Networking/Chat
Url: https://schat.me/

Epoch: 1

# Source0-url: https://github.com/impomezia/schat/archive/refs/heads/master.zip
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar

Source2: %name.desktop
Source4: %name.conf
Source6: schatd.service
Source7: schat-authd.service

Patch1: %name.patch

BuildRequires: pkgconfig(Qt5Gui) pkgconfig(Qt5WebKit) pkgconfig(Qt5Multimedia) pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(xscrnsaver) pkgconfig(hunspell)
BuildRequires: libGeoIP-devel zlib-devel qt5-tools
BuildRequires: gcc-c++

%package -n schatd
Summary: Simple Chat server
Group: Networking/Chat

%description
Simple and powerful cross-platform chat for local networks and the Internet.

%description -n schatd
Simple and powerful cross-platform server for local networks and the Internet.

%package -n %name-server
Summary: Server for IMPOMEZIA Simple Chat (%name)
Group: System/Servers

%description -n %name-server
Server for IMPOMEZIA Simple Chat (%name)

%prep
%setup
%patch1 -p2
rm -rv src/3rdparty/zlib/
rm -rv src/common/plugins/SpellChecker/3rdparty

%build
qmake-qt5 "QMAKE_CFLAGS+=%optflags" "QMAKE_CXXFLAGS+=%optflags" \
          "CONFIG+=debug" \
          PREFIX=%prefix LIBDIR=%_libdir GEOIP=1 schat2.pro
%make_build

%install
%make_install install INSTALL_ROOT=%buildroot
rm -f %buildroot/%_libdir/lib*.so

install -D -p -m 0644 %SOURCE6 %buildroot%_unitdir/schatd.service
install -D -p -m 0644 %SOURCE7 %buildroot%_unitdir/schat-authd.service

install -Dp -m 0644 %SOURCE2 %buildroot/%_desktopdir/%name.desktop
rm -v %buildroot%_desktopdir/schat2.desktop

mkdir -p %buildroot%_sysconfdir/schatd2
mkdir -p %buildroot%_var/lib/schatd2
mkdir -p %buildroot%_logdir/schatd2

install -Dp -m 0644 %SOURCE4 %buildroot%_sysconfdir/schatd2/schat2.conf

%pre -n schatd
%_sbindir/groupadd -r -f %privgroup
%_sbindir/useradd -r -s /dev/null -g %privgroup -d %privpath >/dev/null -c 'schat daemon' %privuser >/dev/null 2>&1 ||:

%post -n schatd
%post_service %{name}d

%preun -n schatd
%preun_service %{name}d

%files
%doc README.md LICENSE
%_bindir/schat2
%_libdir/libschat-client.so.*
%_libdir/libschat.so.*
%_libdir/schat2/
%_datadir/schat2/
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/schat2.png

%files -n schatd
%_sbindir/schatd2
%_sbindir/schat-authd
%_libdir/libschat-rest.so.*
%_libdir/libschat-tufao.so.*
%_libdir/libschatd.so.*
%_libdir/schatd2/
%_datadir/schatd2/
%_unitdir/schatd.service
%_unitdir/schat-authd.service
%attr(0750, schatd, schatd) %dir %_sysconfdir/schatd2
%config(noreplace) %attr(0640, schatd, schatd) %_sysconfdir/schatd2/schat2.conf
%attr(0750, schatd, schatd) %_var/lib/schatd2
%attr(0750, schatd, schatd) %_logdir/schatd2

%changelog
