%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%define libsepol_ver 3.6

Name: setools
Version: 4.5.1
Release: alt1
License: %gpl2plus
URL: https://github.com/SELinuxProject/setools/wiki
Summary: Policy analysis tools for SELinux
Group: System/Base

# https://github.com/SELinuxProject/setools.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-cython
BuildRequires: /proc
#libsetools
BuildRequires: libselinux-devel

# In libsepol defined version: POLICYDB_VERSION_MAX, so rebuild libsepol first if available.
BuildRequires: libsepol-devel >= %libsepol_ver
BuildRequires: libsepol-devel-static >= %libsepol_ver

%description
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

This meta-package depends upon the main packages necessary to run
SETools.

%package -n python3-module-%name
License: %lgpl2plus
Summary: Python bindings for SELinux policy analysis
Group: Development/Python3

%description -n python3-module-%name
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

%package console
Summary: Policy analysis command-line tools for SELinux
Group: System/Base
License: %gpl2plus
Requires: libselinux

%description console
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

%package console-analyses
Summary: Policy analysis command-line tools for SELinux
Group: System/Base
License: %gpl2plus
Requires: libselinux

%description console-analyses
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

%package gui
Summary: Policy analysis graphical tools for SELinux
Group: System/Base
Requires: qt5-assistant

%description gui
SETools is a collection of graphical tools, command-line tools, and
libraries designed to facilitate SELinux policy analysis.

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%find_lang --with-man --all-name %name

egrep 'sechecker\.1|sediff\.1|seinfo\.1|sesearch\.1' %name.lang > %name-console.lang
egrep 'sedta\.1|seinfoflow\.1' %name.lang > %name-console-analyses.lang
egrep 'apol\.1' %name.lang > %name-gui.lang

%files -n python3-module-%name
%doc ChangeLog COPYING COPYING.GPL COPYING.LGPL KNOWN-BUGS README.md
%python3_sitelibdir/setools
%python3_sitelibdir/setools-*.dist-info

%files console -f %name-console.lang
%doc ChangeLog COPYING COPYING.GPL COPYING.LGPL KNOWN-BUGS README.md
%_bindir/sechecker
%_bindir/sediff
%_bindir/seinfo
%_bindir/sesearch
%_man1dir/sechecker.1*
%_man1dir/sediff.1*
%_man1dir/seinfo.1*
%_man1dir/sesearch.1*

%files console-analyses -f %name-console-analyses.lang
%doc ChangeLog COPYING COPYING.GPL COPYING.LGPL KNOWN-BUGS README.md
%_bindir/sedta
%_bindir/seinfoflow
%_man1dir/sedta.1*
%_man1dir/seinfoflow.1*

%files gui -f %name-gui.lang
%doc ChangeLog COPYING COPYING.GPL COPYING.LGPL KNOWN-BUGS README.md
%_bindir/apol
%_man1dir/apol.1*
%python3_sitelibdir/setoolsgui

%changelog
