%set_verify_elf_method strict
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

Name: sg3_utils
Version: 1.48
Release: alt2

Summary: Utilities for devices that use SCSI command sets
License: GPL-2.0-or-later and BSD-2-Clause
Group: System/Kernel and hardware
Url: https://sg.danny.cz/sg/sg3_utils.html
# https://sg.danny.cz/sg/p/%name-%version.tar.xz
Source: %name-%version.tar
Requires: libsgutils = %EVR

%add_findreq_skiplist %_bindir/rescan-scsi-bus.sh

%description
Collection of Linux utilities for devices that use the SCSI command set.
Includes utilities to copy data based on "dd" syntax and semantics
(called sg_dd, sgp_dd and sgm_dd); check INQUIRY data and VPD pages
(sg_inq); check mode and log pages (sginfo, sg_modes and sg_logs); spin
up and down disks (sg_start); do self tests (sg_senddiag); and various
other functions.  See the README, ChangeLog and COVERAGE files. Requires
the linux kernel 2.4 series or later.  In the 2.4 series SCSI generic
device names (e.g. /dev/sg0) must be used.  In the 2.6 series other
device names may be used as well (e.g. /dev/sda).

Warning: Some of these tools access the internals of your system
and the incorrect usage of them may render your system inoperable.

%package -n libsgutils
Summary: Shared library for %name
Group: System/Libraries

%description -n libsgutils
This package contains the shared library for %name.

%package -n libsgutils-devel
Summary: Development library and header files for the sgutils library
Group: Development/C
Requires: libsgutils = %EVR

%description -n libsgutils-devel
This package contains the development %name library and its header files
for developing applications.

%package -n udev-rules-sgutils
Summary: Utilities for devices using the SCSI command set (udev rules)
Group: System/Kernel and hardware
BuildArch: noarch
Requires: %name = %EVR

%description -n udev-rules-sgutils
Udev rules which are associated with the utilities in the %name package.

%prep
%setup
sed -i s/libsgutils2/libsgutils/g */Makefile.*
sed -i s/2:0:0/1:0:0/ lib/Makefile.*

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std
# https://bugzilla.altlinux.org/39183
ln -s libsgutils.so %buildroot%_libdir/libsgutils2.so

mkdir -p %buildroot%_udevrulesdir
for rulesname in 00-scsi-sg3_config 54-before-scsi-sg3_id 55-scsi-sg3_id 58-scsi-sg3_symlink 40-usb-blacklist 59-fc-wwpn-id; do
    install -m 644 scripts/$rulesname.rules %buildroot%_udevrulesdir/
done
install -m 755 scripts/fc_wwpn_id %buildroot%_udevrulesdir/../

%files
%_bindir/*
%_man8dir/*
%doc AUTHORS BSD_LICENSE ChangeLog COPYING COVERAGE CREDITS README README.sg_start

%files -n libsgutils
%_libdir/*.so.*
%doc BSD_LICENSE COPYING

%files -n libsgutils-devel
%_includedir/scsi/*.h
%_libdir/*.so

%files -n udev-rules-sgutils
%_udevrulesdir/*
%_udevrulesdir/../fc_wwpn_id

%changelog
