%define _unpackaged_files_terminate_build 1

%def_with check

Name: shim
Version: 16.1
Release: alt1

Summary: First-stage UEFI bootloader
License: BSD
Group: System/Kernel and hardware
VCS: https://github.com/rhboot/shim
Url: https://github.com/rhboot/shim

Source: %name-%version.tar
Source1: altlinux-ca.cer
Source2: %name-%version-gnu-efi.tar

BuildRequires(pre): rpm-macros-uefi
BuildRequires: pesign >= 0.106
BuildRequires: libelf-devel
BuildRequires: dos2unix

%if_with check
BuildRequires: xxd
BuildRequires: libefivar-devel
%endif

# Shim is only required on platforms implementing the UEFI secure boot
# protocol.
ExclusiveArch: x86_64 aarch64

# Figure out the right file path to use
%global efidir altlinux
# SBAT generation number for ALT (refer to SBAT.md)
%global alt_gen_number 1

%description
Initial UEFI bootloader that handles chaining to a trusted
full bootloader under secure boot environments.

%package -n %name-unsigned
Summary: First-stage UEFI bootloader (unsigned data)
Group: System/Kernel and hardware

%description -n %name-unsigned
Initial UEFI bootloader that handles chaining to a trusted
full bootloader under secure boot environments.
Includes both ia32 and x64 EFI binaries.

%prep
%setup -a 2

echo "shim.altlinux,%alt_gen_number,ALT Linux,shim,%version-%release,https://git.altlinux.org/gears/s/shim.git" > data/sbat.altlinux.csv

%build
MAKEFLAGS="DISABLE_REMOVABLE_LOAD_OPTIONS=1"
if [ -f "%SOURCE1" ]; then
	MAKEFLAGS="VENDOR_CERT_FILE=%SOURCE1 $MAKEFLAGS"
fi

mkdir build
pushd build
  %make_build ${MAKEFLAGS} TOPDIR=.. -f ../Makefile
popd

%ifarch x86_64
mkdir build-ia32
pushd build-ia32
  %make_build ${MAKEFLAGS} TOPDIR=.. ARCH=ia32 -f ../Makefile
popd
%endif

%install
pushd build
make TOPDIR=.. DESTDIR=%buildroot EFIDIR=%efidir \
     -f ../Makefile install-as-data
pesign -h -P -i shim%_efi_arch.efi -h > shim%_efi_arch.hash
install -m 0644 shim%_efi_arch.hash \
        %buildroot%_datadir/shim/%version/%_efi_arch/shim%_efi_arch.hash
install -m 0644 BOOT%_efi_arch_upper.CSV \
        %buildroot%_datadir/shim/%version/%_efi_arch/BOOT%_efi_arch_upper.CSV
popd

%ifarch x86_64
pushd build-ia32
make TOPDIR=.. ARCH=ia32 \
     DESTDIR=%buildroot EFIDIR=%efidir \
     -f ../Makefile install-as-data
pesign -h -P -i shimia32.efi -h > shimia32.hash
install -m 0644 shimia32.hash %buildroot%_datadir/shim/%version/ia32/shimia32.hash
install -m 0644 BOOTIA32.CSV %buildroot%_datadir/shim/%version/ia32/BOOTIA32.CSV
popd
%endif

%check
%make_build test

%files -n %name-unsigned
%doc README.md README.fallback README.tpm COPYRIGHT
%dir %_datadir/shim
%dir %_datadir/shim/%version
%dir %_datadir/shim/%version/%_efi_arch
%_datadir/shim/%version/%_efi_arch/BOOT%_efi_arch_upper.CSV
%_datadir/shim/%version/%_efi_arch/fb%_efi_arch.efi
%_datadir/shim/%version/%_efi_arch/mm%_efi_arch.efi
%_datadir/shim/%version/%_efi_arch/shim%_efi_arch.efi
%_datadir/shim/%version/%_efi_arch/shim%_efi_arch.hash
%ifarch x86_64
%dir %_datadir/shim/%version/ia32
%_datadir/shim/%version/ia32/BOOTIA32.CSV
%_datadir/shim/%version/ia32/fbia32.efi
%_datadir/shim/%version/ia32/mmia32.efi
%_datadir/shim/%version/ia32/shimia32.efi
%_datadir/shim/%version/ia32/shimia32.hash
%endif

%changelog
