
%define _libexecdir %prefix/libexec

Name: signon-ui
Version: 0.17
Release: alt10

Group: System/Libraries
Summary: Online Accounts Sign-on Ui
Url: https://launchpad.net/signon-ui
License: GPLv3

Requires: dbus


ExcludeArch: %not_qt6_qtwebengine_arches
Source: signon-ui-%version.tar
Patch1: 0001-Fix-WebEngine-cache-directory-path.patch
# FC
# ALT
Patch10: alt-fix-compile.patch
Patch11: alt-fix-crash.patch

BuildRequires(pre): rpm-macros-qt6-webengine
BuildRequires: qt6-base-devel qt6-declarative-devel
BuildRequires: accounts-qt6-devel signon-devel libproxy-devel libnotify-devel
BuildRequires: qt6-webengine-devel

%description
Sign-on UI is the component responsible for handling the user interactions which
can happen during the login process of an online account.
It can show password dialogs and dialogs with embedded web pages.

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -n signon-ui-%version
%patch1 -p1
#
%patch10 -p1
%patch11 -p1
sed -i 's/\/lib/\/%{_lib}/g' common-installs-config.pri
sed -i 's|tests| |' signon-ui.pro

%build
export PATH=%_qt6_bindir:$PATH
%qmake_qt6 \
    QMF_INSTALL_ROOT=%prefix \
    PREFIX=%prefix \
    CONFIG+=release \
    CONFIG+=force-foreign-qwindow \
    LIBDIR=%_libdir \
    LIBEXECDIR=%_libexecdir \
    signon-ui.pro

%make_build

%install
%install_qt6

# create directory for provider-specific configuration
mkdir -p %buildroot/%_sysconfdir/signon-ui/webkit-options.d

%files
%doc README TODO NOTES
%_bindir/signon-ui
%_desktopdir/signon-ui.desktop
%_datadir/dbus-1/services/*.service
%_sysconfdir/signon-ui

%changelog
