%def_enable snapshot
%define ver_major 46
%define beta %nil
%define xdg_name org.gnome.SimpleScan

%def_enable packagekit
%def_enable check

Name: simple-scan
Version: %ver_major.0
Release: alt2%beta

Summary: Simple scanning utility
License: GPL-3.0-or-later
Group: Graphics
Url: https://apps.gnome.org/SimpleScan

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

Requires: sane xdg-utils gnome-icon-theme colord
%{?_enable_packagekit:Requires: packagekit}

%define gtk_ver 4.10
%define gusb_ver 0.2.7
%define adw_ver 1.2

BuildRequires(pre): rpm-macros-meson
BuildRequires: meson vala-tools yelp-tools /usr/bin/appstreamcli
BuildRequires: libgtk4-devel >= %gtk_ver libgusb-devel >= %gusb_ver
BuildRequires: libsane-devel zlib-devel
BuildRequires: libcolord-vala
BuildRequires: libcolord-devel libwebp-devel
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
%{?_enable_packagekit:BuildRequires: libpackagekit-glib-devel}

%description
Simple Scan is an easy-to-use application, designed to let users connect their
scanner and quickly have the image/document in an appropriate format.

%prep
%setup -n %name-%version%beta

sed -i 's|libsane-hpaio|hplip-sane|' src/app-window.vala

%build
%meson %{?_disable_packagekit:-Dpackagekit=false}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
%__meson_test

%files -f %name.lang
%_bindir/*
%_desktopdir/*
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_iconsdir/hicolor/*/apps/%{xdg_name}*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/*

%changelog
