%global import_path github.com/containers/skopeo

%global _unpackaged_files_terminate_build 1
%def_without check

Name: skopeo
Version: 1.20.0
Release: alt1

Summary: skopeo is a command line utility that performs various operations on container images and image repositories
License: Apache-2.0
Group: Other
Url: https://github.com/containers/skopeo

Source: %name-%version.tar

Requires: containers-common >= 1:1

ExclusiveArch: %go_arches
BuildRequires(pre): rpm-build-golang
BuildRequires: golang go-md2man
BuildRequires: glib2-devel libgpgme-devel libbtrfs-devel
BuildRequires: libgio-devel libostree-devel libselinux-devel libdevmapper-devel
BuildRequires: libassuan-devel
%if_with check
BuildRequires: /proc
BuildRequires: podman
%endif

%description
Skopeo works with API V2 registries such as Docker registries, the Atomic
registry, private registries, local directories and local OCI-layout
directories. Skopeo does not require a daemon to be running to perform these
operations which consist of:
- Copying an image from and to various storage mechanisms. For example you can
  copy images from one registry to another, without requiring privilege.
- Inspecting a remote image showing its properties including its layers,
  without requiring you to pull the image to the host.
- Deleting an image from an image repository.
- When required by the repository,
  skopeo can pass the appropriate credentials and certificates for
  authentication.

%prep
%setup

%build
export BUILDDIR="$PWD/.gopath"
export IMPORT_PATH="%import_path"
export GOPATH="$BUILDDIR:%go_path"
export GOFLAGS="-mod=vendor"
export GIT_COMMIT=%release

%golang_prepare

pushd .gopath/src/%import_path
#%%golang_build cmd/%%name
%make_build bin/skopeo
for doc in $(find docs -name '*.1.md'); do
    go-md2man -in "$doc" -out "docs/$(basename "${doc%%.md}")"
done
popd

%install
export BUILDDIR="$PWD/.gopath"
export GOPATH="%go_path"
# export IGNORE_SOURCES=1
#%%golang_install
pushd .gopath/src/%import_path
%make DESTDIR=%buildroot PREFIX=%_prefix install-binary install-docs install-completions
popd

%check
make check

%files
%doc README.md
%_bindir/*
%_datadir/bash-completion/completions/%name
%_datadir/fish/vendor_completions.d/skopeo.fish
%_datadir/zsh/site-functions/_skopeo
%_man1dir/%{name}*

%changelog
