%define _unpackaged_files_terminate_build 1

Name: slapi-nis
Version: 0.60.0
Release: alt2

Summary: NIS Server and Schema Compatibility plugins for Directory Server
License: GPL-3.0
Group: System/Base
Url: http://pagure.io/slapi-nis/
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires: 389-ds-base-devel
BuildRequires: glibc-utils
BuildRequires: libldap-devel
BuildRequires: libnsl2-devel
BuildRequires: libtirpc-devel
BuildRequires: libnspr-devel
BuildRequires: libnss-devel
BuildRequires: libsss_nss_idmap-devel
BuildRequires: pam-devel
BuildRequires: /usr/bin/rpcgen

ExcludeArch: %ix86 armh

Requires: 389-ds-base >= 1.3.5.6

%description
This package provides two plugins for Red Hat and 389 Directory Server.

The NIS Server plugin allows the directory server to act as a NIS server
for clients, dynamically generating and updating NIS maps according to
its configuration and the contents of the DIT, and serving the results to
clients using the NIS protocol as if it were an ordinary NIS server.

The Schema Compatibility plugin allows the directory server to provide an
alternate view of entries stored in part of the DIT, optionally adding,
dropping, or renaming attribute values, and optionally retrieving values
for attributes from multiple entries in the tree.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
    --disable-static \
    --with-ldap=openldap \
    --with-nsswitch \
    --with-pam \
    --with-pam-service=system-auth \
    --with-tcp-wrappers=no \
    --with-tirpc=yes \
    --enable-be-txns-by-default \
    --with-sss-nss-idmap \
    --with-idviews
sed -i -e 's,%_libdir/dirsrv/plugins/,,g' -e 's,.so$,,g' doc/examples/*.ldif
%make_build

%install
%makeinstall_std

%files
%doc COPYING NEWS README STATUS doc/*.txt doc/examples/*.ldif doc/ipa
%_man1dir/nisserver-plugin-defs.1.*
%_libdir/dirsrv/plugins/nisserver-plugin.so
%_libdir/dirsrv/plugins/schemacompat-plugin.so
%_sbindir/nisserver-plugin-defs
%exclude %_libdir/dirsrv/plugins/*.la

%changelog
