%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%define sover 2
%define modsover 0
%add_verify_elf_skiplist %_libdir/libspeechd_module.*

%define libexec %_libdir

Name: speech-dispatcher
Version: 0.12.1
Release: alt2

Summary: A speech output processing service
License: GPL-2.0-or-later
Group: Sound
URL: http://www.freebsoft.org/speechd
VCS: https://github.com/brailcom/speechd

Source: %name-%version.tar
Source1: speech-dispatcher.filetrigger
SOURCE2: speech-dispatcher.control
Patch0: speech-dispatcher-0.8-alt-flite.patch
Patch1: modules_order-fix.patch

BuildRequires: libdotconf-devel >= 0.3
BuildRequires: gcc-c++ glib2-devel glibc-devel-static intltool
BuildRequires: libXau-devel  libltdl7-devel
BuildRequires: libalsa-devel libao-devel
BuildRequires: flite-devel  libespeak-ng-devel svox-pico
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-base python3-devel
BuildRequires: libsndfile-devel libpulseaudio-devel
BuildRequires: makeinfo


%description
Speech Dispatcher is a part of the Free(b)soft project, which is
intended to allow blind and visually impaired people to work with
computer and Internet based on free software.

%package -n libspeechd%sover
Summary: Client library for speech-dispatcher
Group: System/Libraries
Provides: libspeechd = %EVR
obsoletes: libspeechd < %EVR

%description -n libspeechd%sover
Applications can use this library to communicate with speech-dispatcher
service and produce speech output.

%package -n libspeechd-devel
Group: Development/C
Summary: Development files to use libspeechd to connect to speech-dispatcher

%description -n libspeechd-devel
Developers can use this library to connect to speech-dispatcher daemon
and produce speech output.

%package utils
Group: Sound
Summary: Various utilities for speech-dispatcher
Requires: %name = %EVR

%description utils
Various utilities for speech-dispatcher

%package module-flite
Group: Sound
Summary: Flite support for speech-dispatcher
Requires: %name = %EVR

%description module-flite
Flite support for speech-dispatcher

%package module-festival
Group: Sound
Summary: Festival support for speech-dispatcher
Requires: %name = %EVR

%description module-festival
Festival support for speech-dispatcher

%package module-pico
Group: Sound
Summary: Pico support for speech-dispatcher
Requires: %name = %EVR

%description module-pico
Pico support for speech-dispatcher

%package -n python3-module-speechd
Summary: Python client for Speech Dispatcher
Group: Development/Python
BuildArch: noarch
Requires: %name = %EVR

%description -n python3-module-speechd
This python module allows programmsaccess speech-dispatcher service.

%prep
%setup
%patch0 -p1
%patch1 -p2


%build
%add_optflags -D_FILE_OFFSET_BITS=64

%autoreconf
%configure --with-espeak-ng \
	   --with-flite  \
	   --with-pico \
	   --with-pulse \
	   --with-alsa \
	   --with-libao \
	   --with-oss \
	   --without-voxin \
	   --without-kali \
	   --without-ibmtts \
	   --without-baratinoo \
	   --disable-static \
	   --with-module-bindir=%{_libdir}/speech-dispatcher-modules
	   %nil
%make_build

%install
%make_install DESTDIR='%buildroot' pyexecdir=%python3_sitelibdir_noarch install

# install filetrigger
install -D -m 755 %SOURCE1 %buildroot/%_rpmlibdir/speech-dispatcher.filetrigger

# install controle
install -Dpm 755 %SOURCE2 %buildroot%_controldir/%name

# unpackaged files
find %buildroot%_libdir -name '*.la' -delete

%find_lang %name

%files -f %name.lang
%doc FAQ NEWS README.md README.overview.md
%_bindir/speech-dispatcher
%config %_sysconfdir/%name
%_controldir/%name
%dir %_libdir/%name
%_libdir/%name/spd*.so
%dir %_libdir/%name-modules
%_libdir/%name-modules/sd_dummy
%_libdir/%name-modules/sd_espeak*
%_libdir/%name-modules/sd_generic
%_libdir/%name-modules/sd_cicero
%_libdir/%name-modules/sd_openjtalk
%_libdir/libspeechd_module.so.%modsover
%_libdir/libspeechd_module.so.%modsover.*
%_datadir/sounds/%name
%_datadir/%name
%_infodir/*
%_rpmlibdir/speech-dispatcher.filetrigger

%files -n libspeechd%sover
%_libdir/libspeechd.so.%sover
%_libdir/libspeechd.so.%sover.*

%files -n libspeechd-devel
%_includedir/*
%_libdir/libspeechd.so
%_libdir/libspeechd_module.so
%_pkgconfigdir/*

%files utils
%_bindir/spd-conf
%_bindir/spd-say
%_bindir/spdsend

%files module-flite
%_libdir/%name-modules/sd_flite

%files module-festival
%_libdir/%name-modules/sd_festival

%files module-pico
%_libdir/%name-modules/sd_pico

%files -n python3-module-speechd
%python3_sitelibdir_noarch/*

%changelog
