%define optflags_lto %nil

Name: syslinux
Version: 4.04
Release: alt19
Serial: 2

Summary: Simple kernel loader which boots from a FAT filesystem
License: GPL
Group: System/Kernel and hardware
Url: http://syslinux.zytor.com/

ExclusiveArch: %ix86 x86_64

Requires: mtools
Requires: %name-data = %serial:%version-%release

Source0: %name-%version.tar.bz2
Source1: isolinux-config
Source2: README.gfxboot
# SuSE
Patch1: syslinux-4.04-iso9660.diff
Patch2: syslinux-4.04-cwd.diff
Patch3: syslinux-4.04-noinitrd.diff
Patch4: syslinux-4.04-mboot_bootif.diff
Patch5: syslinux-4.04-md5pass.diff
Patch6: syslinux-4.04-gcc47.diff
Patch7: syslinux-4.04-libext2fs.diff
Patch8: syslinux-4.04-isohybrid_efi.diff
Patch9: syslinux-4.04-isohybrid_efi_optional.diff
Patch10: syslinux-4.04-isohybrid_mbr.diff
Patch11: syslinux-4.04-localboot.diff
Patch12: syslinux-4.04-geometry.diff
Patch13: syslinux-4.04-nostrip.diff
Patch14: syslinux-4.04-timeout.diff
Patch15: syslinux-4.04-cache_fix.diff
Patch16: syslinux-4.04-mtime.diff
Patch17: syslinux-4.04-miniacc.diff
Patch18: syslinux-4.04-align.diff
Patch19: syslinux-4.04-reproducible.patch
Patch20: syslinux-4.04-python3.diff
Patch21: sysmacros.patch
Patch22: remove-note-gnu-section.patch
Patch23: syslinux-4.04-lzo.diff
Patch24: syslinux-4.04-gcc10.diff
Patch25: syslinux-4.04-fno-pie.diff

#BuildPrereq: nasm perl-base
BuildRequires: rpm-build-python3
BuildRequires: nasm perl-Crypt-PasswdMD5 perl-Digest-SHA1 libe2fs-devel
#linux-libc-headers
BuildRequires: libuuid-devel

#set_gcc_version 4.7

%description
Syslinux is a simple kernel loader. It normally loads the kernel (and an 
optional initrd image) from a FAT filesystem. It can also be used as a
PXE bootloader during network boots.

%package extlinux
Group: System/Kernel and hardware
Summary: The EXTLINUX bootloader, for booting the local system.
Requires: %name = %serial:%version-%release
%description extlinux
The EXTLINUX bootloader, for booting the local system, as well as all
the SYSLINUX/PXELINUX modules in /boot.

%package tftpboot
Group: System/Kernel and hardware
Summary: SYSLINUX modules in /tftpboot, available for network booting
Requires: %name = %serial:%version-%release
%description tftpboot
All the SYSLINUX/PXELINUX modules directly available for network
booting in the /tftpboot directory.

%package devel
Summary: Simple kernel loader which boots from a FAT filesystem, devel path
Group: System/Kernel and hardware
Requires: %name = %serial:%version

%description devel
Read main packages description

%package data
Summary: Simple kernel loader which boots from a FAT filesystem, x86 loader binaries
Group: System/Kernel and hardware
BuildArch: noarch

%description data
This package contains a set of syslinux loader binaries for x86-compatible
architectures.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p0
%patch7 -p0
%patch8 -p0
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p0
%patch14 -p1
%patch15 -p1
#%patch16 -p1
%patch17 -p0
%patch18 -p0
%patch19 -p1
%patch20 -p0
%patch21 -p1
%patch22 -p1
%patch23 -p0
%patch24 -p0
%patch25 -p2
install -m 0644 %SOURCE2 .
sed -i 's,GCC_VERSION,_&,g' gpxe/src/arch/i386/Makefile

%build
export CFLAGS="%optflags -fno-stack-protector"
export CC="gcc"
export HOST_CC="$CC"
%make_build spotless
%make


%install
%make \
	INSTALLDIR=%buildroot \
	INSTALLROOT=%buildroot \
	BINDIR=%_bindir \
	SBINDIR=%_bindir \
	DATADIR=%_libexecdir \
	INCDIR=%_includedir \
	MANDIR=%_mandir \
	EXTLINUXDIR=/boot/extlinux \
	install-all
#	TFTPBOOT=/tftpboot \

rm -rf %buildroot/tftpboot
rm -rf %buildroot/%_libexecdir/%name/com32

mkdir -p %_sysconfdir
#ln -s `relative /boot/extlinux/extlinux.conf %_sysconfdir/extlinux.conf` %buildroot/%_sysconfdir/extlinux.conf

for f in ldlinux.sys ldlinux.bss
do
    install -m 0644 core/$f %buildroot/%_libexecdir/%name/
done

install -m 0755 %SOURCE1 %buildroot/%_bindir


%files
%doc NEWS README* doc/* sample/sample.*
%_bindir/*
%exclude %_bindir/extlinux
%_man1dir/*.1.*

%files data
%dir %_libexecdir/%name/
%_libexecdir/%name/*

%files extlinux
%_bindir/extlinux
/boot/extlinux

%changelog
