%set_verify_elf_method relaxed

Name: tac_plus
Version: 4.0.4.28
Release: alt2
Epoch: 1
License: BSD
Group: System/Servers
Summary: TACACS+ server based on Cisco engineering release
Url: http://www.shrubbery.net/tac_plus/
Source:  tacacs-F%version.tar
Source1: tac_plus.conf
Source2: tac_plus.pamd
Source3: tac_plus.init
Source4: tac_plus.sysconfig
Source5: README
Source6: tac_plus.logrotate
Source7: tac_plus.service
Patch0: tacacs+-F4.0.4.28-k1.diff
Patch1: tacacs+-F4.0.4.28.diff
Patch2: tacacs-nolibnsl.diff

BuildRequires: flex gcc-c++ libpam-devel chrpath libnsl2-devel

%description
The base source for this TACACS+ package is Cisco's publicly available TACACS+
"developer's kit", for which we are grateful.

We needed a way to limit certain groups within the company from logging into
or getting enable access on certain devices. Access lists (ACLs) of a sort have
been added that match against the address of the device speaking with the
daemon.

Along the way we have also added autoconf, expanded the manual pages,
cleaned-up various formatting and STD C nits, added PAM authentication support,
and fixed a few LP64 problems.

Of course we have also received some enchancement requests from users. One of
which was the addition of a host clause (per-host configuration). This has been
added; ported from Devrim Seral's implementation. See the documentation for
further information.

Note: this version have patch applied from http://bakacsin.ki.iif.hu/~kissg/pd/tac_plus/

%package devel
Summary: TAC Plus development files
Group: Development/C
Requires: %name = %version
%description devel
Development files for TAC Plus

%package -n libtacacs1
Summary: TACACS+ library
Group: Development/C
%description -n libtacacs1
This package contains TACACS+ library

%prep
%setup -n tacacs-F%version
%patch0 -p1 -b .k1
%patch1 -p1
%patch2 -p2

%build
%configure \
 --disable-static \
 --enable-acls \
 --enable-uenable \
 --enable-maxsess \
 --enable-finger \
 --enable-debug \
 --enable-warn \
 --enable-mschap \
 --without-libwrap

%make

%install
%makeinstall_std

mkdir -p %buildroot/{%_initdir,%_sysconfdir/{pam.d,sysconfig}}
install -m 640 %SOURCE1 %buildroot/%_sysconfdir/
install -m 644 %SOURCE2 %buildroot/%_sysconfdir/pam.d/%name
install -m 755 %SOURCE3 %buildroot/%_initdir/%name
install -m 644 %SOURCE4 %buildroot/%_sysconfdir/sysconfig/%name
install -m 644 %SOURCE5 .
install -pD -m644 %SOURCE6 %buildroot%_sysconfdir/logrotate.d/%name
install -pD -m644 %SOURCE7 %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_logdir
touch %buildroot%_logdir/{tacwho.log,tac_plus.log,tac_plus.acct}

for i in %buildroot%_sbindir/* %buildroot%_libdir/*.so.*
do
	chrpath -d $i ||:
done

%post
%post_service %name

%preun
%preun_service %name

%files devel
%_includedir/tacacs.h
%_libdir/libtacacs.so

%files -n libtacacs1
%_libdir/libtacacs.so.*

%files
%_bindir/tac_*
%_sbindir/tac_*
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/pam.d/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/logrotate.d/%name
%_initdir/%name
%_unitdir/%name.service
%_man5dir/tac_plus.conf.5.*
%_man8dir/tac_plus.8.*
%_man8dir/tac_pwd.8.*
%attr(644,root,root) %_logdir/tac_plus.log
%attr(644,root,root) %_logdir/tac_plus.acct
%attr(600,root,root) %_logdir/tacwho.log
%doc users_guide COPYING FAQ INSTALL CHANGES README do_auth.py tac_convert

%changelog
