%define _unpackaged_files_terminate_build 1

Name: thrift
Version: 0.18.1
Release: alt1
Summary: Software framework for cross-language services development
Group: Development/Other
License: Apache-2.0
Url: https://thrift.apache.org/
Source: %name-%version.tar
Patch0001: 0001-fix-install-thrift_c_glibpc.patch

BuildRequires(pre): rpm-build-python3 rpm-macros-cmake
BuildRequires: boost-devel boost-filesystem-devel boost-program_options-devel boost-locale-devel
BuildRequires: cmake ninja-build flex
BuildRequires: gcc-c++
BuildRequires: glib2-devel libgio-devel
BuildRequires: libevent-devel
BuildRequires: libssl-devel
BuildRequires: qt5-base-devel
BuildRequires: zlib-devel

Provides: lib%name = %EVR

%description
The Apache Thrift software framework for cross-language services
development combines a software stack with a code generation engine to
build services that work efficiently and seamlessly between C++, Java,
Python, %{?php_langname}and other languages.

%package devel
Group: Development/C++
Summary: Development files for %name
Provides: lib%name-devel = %EVR
Requires: %name = %EVR
#Requires: boost-complete

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package qt5
Group: Development/Other
Summary: Qt5 support for %name
Requires: %name = %EVR

%description qt5
The %name-qt package contains Qt bindings for %name.

%package glib
Group: Development/Other
Summary: GLib support for %name
Requires: %name = %EVR

%description glib
The %name-qt package contains GLib bindings for %name.

%package -n python3-module-%name
Group: Development/Python3
Summary: Python 3 support for %name
BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools
Requires: %name = %EVR

%description -n python3-module-thrift
The python3-%name package contains Python bindings for %name.

%prep
%setup
%patch0001 -p1

%build
export PYTHON=%__python3
%cmake \
  -DBUILD_COMPILER=ON \
  -DBUILD_SHARED_LIBS=ON \
  -DWITH_NODEJS=OFF \
  -DWITH_JAVASCRIPT=OFF \
  -DBUILD_PYTHON=ON \
  -DCMAKE_INSTALL_DIR=%_libdir/cmake \
  -DPKGCONFIG_INSTALL_DIR=%_pkgconfigdir \
  -GNinja
%cmake_build

%install
%cmake_install
#fix cmake
sed -i 's|/usr//usr|%_prefix|g' %buildroot%_libdir/cmake/thrift/ThriftConfig.cmake
pushd lib/py
%python3_install
popd

%files
%doc LICENSE NOTICE
%_bindir/%name
%_libdir/libthrift.so.*
%_libdir/libthriftnb.so.*
%_libdir/libthriftz.so.*

%files glib
%_libdir/libthrift_c_glib*.so.*

%files qt5
%_libdir/libthriftqt5.so.*

%files devel
%_includedir/%name
%_libdir/*.so
%_pkgconfigdir/*
%_libdir/cmake/%name
%doc NOTICE

%files -n python3-module-%name
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%version-py*.egg-info

%changelog
