%def_disable docs
# Upstream tests are broken for now:
# new function thunarx_provider_module_unuse is not
# in the thunarx.symbols list.
%def_disable check

Name: thunar
Version: 4.20.6
Release: alt1

Summary: Thunar File Manager for the Xfce Desktop Environment
Summary (ru_RU.UTF-8): Файловый менеджер Thunar
Group: Graphical desktop/XFce
License: GPLv2+ and LGPLv2+
Url: https://docs.xfce.org/xfce/thunar/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/thunar.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-xfce4 >= 0.2.0

BuildRequires: xfce4-dev-tools
BuildRequires: libxfce4panel-gtk3-devel >= 4.12.0 libxfconf-devel >= 4.12.0 libexo-gtk3-devel >= 4.19.0
BuildRequires: libxfce4util >= 4.17.2 libxfce4ui-gtk3-devel >= 4.17.6
BuildRequires: libSM-devel libexif-devel libpcre2-devel
BuildRequires: libpango-devel
BuildRequires: libnotify-devel libgudev-devel
BuildRequires: desktop-file-utils
# NOTE: gtk-doc is required by build system even if docs are disabled.
BuildRequires: gtk-doc
# For /usr/share/gettext/its/polkit.{its,loc}
# See https://gitlab.xfce.org/xfce/thunar/-/issues/1403
BuildRequires: libpolkit-devel

%define _unpackaged_files_terminate_build 1

Requires: lib%name = %version-%release
Requires: eject
Requires: exo-utils
Requires: xfconf-utils

Obsoletes: Thunar < 1.3.1
Provides: Thunar = %version-%release

%description
Thunar File Manager for the Xfce desktop environment.

%description -l ru_RU.UTF-8
Файловый менеджер Thunar используемый в окружении рабочего стола Xfce.

%package -n lib%name-devel
Summary: Development files for %name
Group: Graphical desktop/XFce
License: LGPLv2+
Requires: lib%name = %version-%release
Obsoletes: libThunar-devel < 1.3.1
Provides: libThunar-devel = %version-%release

%description -n lib%name-devel
This package contains development files required to build
%name-based software.

%package -n lib%name
Summary: Shared libraries for %name
Group: Graphical desktop/XFce
License: LGPLv2+
Obsoletes: libThunar < 1.3.1
Provides: libThunar = %version-%release

%description -n lib%name
This package contains libraries for %name.

%if_enabled docs
%package -n lib%name-devel-doc
Summary: Development documentation for lib%name
Group: Development/Documentation
License: GFDL-1.1+
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for lib%name.
%endif

%prep
%setup
%patch -p1
%xfce4_cleanup_version

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-largefile \
	--enable-exif \
	--enable-pcre2 \
	--enable-gio-unix \
	--with-custom-thunarx-dirs-enabled=no \
%if_enabled docs
	--enable-gtk-doc \
%else
	--disable-gtk-doc \
%endif
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang thunar
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Filesystem \
	--add-category=FileTools \
	%buildroot%_desktopdir/thunar-bulk-rename.desktop

%check
make check

%files -f thunar.lang
%doc README.md NEWS AUTHORS
%config(noreplace) %_sysconfdir/xdg/Thunar/
%_bindir/*
%_desktopdir/*
%_man1dir/*
%_datadir/dbus-1/services/*
%_datadir/polkit-1/actions/org.xfce.thunar.policy
%_datadir/metainfo/org.xfce.thunar.appdata.xml
%_datadir/Thunar
%_datadir/xfce4/panel/plugins/*.desktop
%_user_unitdir/thunar.service
%_libdir/xfce4/panel/plugins/*.so
%exclude %_libdir/xfce4/panel/plugins/*.la
%dir %_libdir/thunarx-*/
%_libdir/thunarx-*/*.so
%_libdir/Thunar/
%_iconsdir/hicolor/*/*/*
%_docdir/thunar

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_includedir/thunarx-*/
%_libdir/*.so

%if_enabled docs
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%exclude %_libdir/thunarx-*/*.la

%changelog
