%def_enable snapshot
%define optflags_lto %nil
%define _libexecdir %_prefix/libexec

%define ver_major 43
%define beta %nil
%define xdg_name org.gnome.Totem

%define parser_ver 3.26.5
%define gst_api_ver 1.0
%define gst_ver 1.21.1
%define gst_plugins_ver 1.21.1
%define gtk_ver 3.22.0
%define grilo_ver 0.3.13
%define grilo_plugins_ver 0.3.12
%define glib_ver 2.36.0
%define peas_ver 1.1.0
%define handy_ver 1.5

%def_disable static
%def_enable vala

%if_enabled vala
%def_enable rotation
%endif

%def_enable introspection
%def_enable gtk_doc
%def_disable python
%def_disable coherence_upnp
%def_disable jamendo
# removed since 3.33.0
%def_disable lirc
%def_disable brasero

Name: totem
Version: %ver_major.2
Release: alt2%beta

Summary: Movie player for GNOME 3
Group: Video
License: GPL-2.0-or-later
Url: https://wiki.gnome.org/Apps/Videos

Vcs: https://gitlab.gnome.org/GNOME/totem.git

%if_enabled snapshot
Source: %name-%version%beta.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version%beta.tar.xz
%endif
Patch10: totem-43.2-alt-32-bit-format.patch

Obsoletes: %name-gstreamer < %version %name-backend-gstreamer < %version %name-backend-xine < %version
Obsoletes: %name-plugins-mythtv  %name-plugins-galago
Obsoletes: %name-plugins-bemused  %name-plugins-youtube
Obsoletes: %name-plugins-publish  %name-plugins-iplayer %name-plugins-grilo
Obsoletes: mozilla-plugin-%name
Provides: %name-backend = %version %name-backend-gstreamer = %version %name-backend-xine = %version

Requires: lib%name = %EVR
Requires: %name-video-thumbnailer = %EVR
Requires: dconf gnome-icon-theme
Requires: gstreamer%gst_api_ver >= %gst_ver
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: iso-codes
Requires: grilo-plugins >= %grilo_plugins_ver

%add_python3_compile_include %_libdir/%name/plugins

BuildRequires(pre): rpm-macros-meson rpm-build-gnome rpm-build-gir
BuildRequires: meson gcc-c++ gtk-doc perl-podlators
BuildRequires: db2latex-xsl yelp-tools
%{?_enable_nvtv:BuildRequires: libnvtv-devel >= 0.4.5}
BuildRequires: pkgconfig(epoxy)
BuildRequires: gstreamer%gst_api_ver-devel >= %gst_ver
BuildRequires: gst-plugins%gst_api_ver-devel >= %gst_plugins_ver
BuildRequires: gstreamer%gst_api_ver-utils >= %gst_ver
BuildRequires: gst-plugins-base%gst_api_ver
BuildRequires: gst-plugins-good%gst_api_ver
BuildRequires: gst-plugins-bad%gst_api_ver-devel
BuildRequires: glib2-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libgio-devel libpeas-devel >= %peas_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libtotem-pl-parser-devel >= %parser_ver
BuildRequires: libgrilo-devel >= %grilo_ver
BuildRequires: libgnome-desktop3-devel gsettings-desktop-schemas-devel
BuildRequires: libX11-devel libXrandr-devel libXi-devel
BuildRequires: pkgconfig(libportal-gtk3)
%if_enabled python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-pygobject3-devel pylint-py3
%endif
%{?_enable_introspection:BuildRequires: libtotem-pl-parser-gir-devel libgtk+3-gir-devel libpeas-gir-devel}
%{?_enable_vala:BuildRequires: vala-tools}
%{?_enable_lirc:BuildRequires: liblirc-devel}
%{?_enable_check:BuildRequires: desktop-file-utils /usr/bin/appstreamcli}

%description
Totem is simple movie player for the Gnome desktop.
It features a simple playlist, a full-screen mode, seek and volume
controls, as well as a pretty complete keyboard navigation.

%package -n lib%name
Summary: Totem Library
License: LGPLv2+
Group: System/Libraries

%description -n lib%name
This package provides shared library for Totem movie player.

%package -n lib%name-devel
Summary: Development files for Totem Library
License: LGPLv2+
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package provides files required to develop programs that use
Totem library.

%package -n lib%name-gir
Summary: GObject introspection data for the Totem library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Totem library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Totem library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Totem library

%package plugins
Summary: default plugins for Totem
Group: Video
Requires: %name = %EVR

%description plugins
A default plugins for Totem:
	screensaver
	skipto
	properties
	media-player-keys
%{?_enable_python:	pythonconsole
	opensubtitles}
	mpris

%package plugins-lirc
Summary: LIRC (Infrared remote) plugin for Totem
Group: Video
Requires: %name = %EVR

%description plugins-lirc
A plugin to add LIRC (Infrared remote) support to Totem.

%package plugins-rotation
Summary: Rotation plugin for Totem
Group: Video
Requires: %name = %EVR

%description plugins-rotation
A plugin to allow videos to be rotated if they're in the wrong orientation.

%package plugins-jamendo
Summary: Plugin for jamendo.com music collection
Group: Video
Requires: %name = %EVR
%py_requires json

%description plugins-jamendo
A plugin to allow you to listen to the large collection of Creative
Commons licensed music on Jamendo

%package plugins-coherence_upnp
Summary: Coherence DLNA/UPnP totem plugin
Group: Video
Requires: %name = %EVR
Requires: python-module-coherence coherence

%description plugins-coherence_upnp
This package contains a DLNA/UPnP client for Totem powered by Coherence

%package plugins-brasero
Summary: Video disc recorder plugin for Totem
Group: Video
Requires: %name = %EVR
Requires: brasero

%description plugins-brasero
This package contains plugin that allow record (S)VCDs or video DVDs
with Brasero

%package devel-doc
Summary: Development documentation for Totem
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name < %version

%description devel-doc
This package provides Totem reference manual

%package video-thumbnailer
Summary: Totem video thumbnailer
Group: Video
Requires: gst-plugins-base%gst_api_ver
Requires: gst-plugins-good%gst_api_ver
Requires: gst-plugins-bad%gst_api_ver
Requires: gst-plugins-ugly%gst_api_ver
Requires: gst-libav
Requires: iso-codes

%description video-thumbnailer
This package provides a video thumbnailer from Totem package that can be
used by other applications like filemanagers.

%prep
%setup -n %name-%version%beta
%ifarch %ix86 armh
%patch10 -b .format
%endif

subst "s|'pylint'|'pylint.py3'|" meson.build

%build
%meson \
    %{?_disable_python:-Denable-python=no} \
    %{?_enable_gtk_doc:-Denable-gtk-doc=true}
%nil
# https://github.com/mesonbuild/meson/issues/1994
%meson_build -j1

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%exclude %_bindir/%name-video-thumbnailer
%dir %_libdir/%name
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*.svg
%_man1dir/*
%exclude %_man1dir/%name-video-thumbnailer.1.*
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/org.gnome.totem.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.totem.enums.xml
%_datadir/GConf/gsettings/totem.convert
%_datadir/metainfo/%xdg_name.appdata.xml
%doc AUTHORS NEWS README COPYING

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-gir-devel
%_girdir/*.gir
%endif

%files plugins
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/autoload-subtitles/
%_libdir/%name/plugins/im-status/
%_libdir/%name/plugins/mpris/
%_libdir/%name/plugins/open-directory/
%{?_enable_python:%_libdir/%name/plugins/opensubtitles/}
%_libdir/%name/plugins/properties/
%{?_enable_python:%_libdir/%name/plugins/pythonconsole/}
%_libdir/%name/plugins/recent/
%_libdir/%name/plugins/save-file/
%_libdir/%name/plugins/screensaver/
%_libdir/%name/plugins/screenshot/
%_libdir/%name/plugins/skipto/
%_libdir/%name/plugins/variable-rate/
%{?_enable_python:%config %_datadir/glib-2.0/schemas/org.gnome.totem.plugins.opensubtitles.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.totem.plugins.pythonconsole.gschema.xml
%_datadir/GConf/gsettings/opensubtitles.convert
%_datadir/GConf/gsettings/pythonconsole.convert}

%if_enabled lirc
%files plugins-lirc
%_libdir/%name/plugins/lirc/
%endif

%if_enabled rotation
%files plugins-rotation
%_libdir/%name/plugins/rotation/
%endif

%if_enabled jamendo
%files plugins-jamendo
%_libdir/%name/plugins/jamendo/
%_datadir/glib-2.0/schemas/org.gnome.totem.plugins.jamendo.gschema.xml
%_datadir/GConf/gsettings/jamendo.convert
%endif

%if_enabled coherence_upnp
%files plugins-coherence_upnp
%_libdir/%name/plugins/coherence_upnp/
%endif

%if_enabled brasero
%files plugins-brasero
%_libdir/%name/plugins/brasero-disc-recorder/
%endif

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%files video-thumbnailer
%_bindir/%name-video-thumbnailer
%_libexecdir/%name-gallery-thumbnailer
%_man1dir/%name-video-thumbnailer.1.*
%_datadir/thumbnailers/%name.thumbnailer

%changelog
