%define _cmake__builddir BUILD

Name:     touchegg
Version:  2.0.17
Release:  alt1

Summary:  Linux multi-touch gesture recognizer
License:  GPL-3.0
Group:    Other
Url:      https://github.com/JoseExposito/touchegg

Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %name-%version.tar
Patch1:   touchegg-alt-remove-static.patch

BuildRequires(pre): rpm-build-ninja
BuildRequires(pre): cmake
BuildRequires: gcc-c++
BuildRequires: libXdmcp-devel
BuildRequires: libXrandr-devel
BuildRequires: libXtst-devel
BuildRequires: libcairo-devel
BuildRequires: libgtk+3-devel
BuildRequires: libinput-devel
BuildRequires: libpcre-devel
BuildRequires: libpugixml-devel
BuildRequires: libudev-devel
BuildRequires: libffi-devel
BuildRequires: libsystemd-devel

%description
Touchegg is an app that runs in the background and transform the gestures you
make on your touchpad into visible actions in your desktop.

%prep
%setup
%ifarch %e2k
# because of "multiple definition of" errors at linking
%define lcc_fix() \
  sed -i "1i #define preferred_separator preferred_separator_$(echo %1 | tr /- __)" src/%1.cpp
%lcc_fix config/xml-config-loader
%lcc_fix utils/client-lock
%lcc_fix utils/paths
%lcc_fix main
%else
%patch1 -p1
%endif

%build
%cmake -GNinja -Wno-dev
%ninja_build -C BUILD

%install
%ninja_install -C BUILD

%preun
%preun_service %name

%post
%post_service %name

%files
%doc *.md
%_bindir/%name
%_sysconfdir/xdg/autostart/%name.desktop
%_datadir/%name
%_unitdir/%name.service

%changelog
