# SPDX-License-Identifier: GPL-2.0-only
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

# Python plugin support (not the API).
# Also requires `unresolved=normal`
%def_without python

Name:     trace-cmd
Version: 3.2
Release: alt1

Summary:  A front-end for Ftrace Linux kernel internal tracer
License:  GPL-2.0 and LGPL-2.1
Group:    Development/Debug
Url:      https://trace-cmd.org/
Vcs:      https://git.kernel.org/pub/scm/utils/trace-cmd/trace-cmd.git
# List:   https://lore.kernel.org/linux-trace-devel/
# List:   https://lore.kernel.org/linux-trace-users/
# Bugs:   https://bugzilla.kernel.org/buglist.cgi?component=Trace-cmd%%2FKernelshark&product=Tools
#
# Poorly documented.
# Presentation: https://lwn.net/Articles/410200/ (2010)
# Article: http://wrightrocket.blogspot.com/2019/07/linux-performance-tool-trace-cmd.html

Source:   %name-%version.tar
%if_with python
BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
# else: 'python-dev is not installed, not compiling python plugins'
%endif
BuildRequires: asciidoc
BuildRequires: banner
BuildRequires: chrpath
BuildRequires: libaudit-devel
BuildRequires: libtraceevent-devel
BuildRequires: libtracefs-devel
BuildRequires: libzstd-devel
BuildRequires: swig
BuildRequires: xmlto
%{?!_without_check:%{?!_disable_check:BuildRequires: CUnit-devel rpm-build-vm}}

%description
The trace-cmd(1) command interacts with the Ftrace tracer that is built inside
the Linux kernel. It interfaces with the Ftrace specific files found in the
debugfs file system under the tracing directory.

%package -n libtracecmd
# Libtracecmd which is compiled from the same source have different upstream
# version numbering. But we cannot set version for sub-package.
Summary: trace-cmd libraries
Group: System/Libraries
Conflicts: trace-cmd-libs < %EVR
Obsoletes: trace-cmd-libs < %EVR

%description -n libtracecmd
%summary.

%package -n libtracecmd-devel
Summary: Development headers of libtracecmd
Group: Development/C
Requires: libtracecmd = %EVR

%description -n libtracecmd-devel
%summary.

%package -n python3-module-tracecmd
Summary: Python plugin support for libtracecmd
Group: Development/Python3
Requires: libtracecmd = %EVR
Provides: python3(tracecmd)
Conflicts: trace-cmd-python3 < %EVR
Obsoletes: trace-cmd-python3 < %EVR

%description -n python3-module-tracecmd
%summary.

%prep
%setup
sed -i s/not-a-git-repo/%version-%release/ scripts/utils.mk
sed -i 's!\(BASH_COMPLETE_DIR\) .*!\1 = %_datadir/bash-completion/completions/!' Makefile

# XXX: Temporary fix Makefiles for make 4.4 or they will infinite loop.
sed -i '/ = .*shell/s/=/:=/' Makefile

%build
%define optflags_lto %nil
%add_optflags -Wno-unused-result %(getconf LFS_CFLAGS)
export CFLAGS="%optflags -D_GNU_SOURCE"
# If libtracecmd.so is parallel-built together with all_cmd, libtracecmd.so
# will miss some functions that will be mis-linked to trace-cmd instead.
%make_build prefix=%_prefix libdir=%_libdir V=1 \
	libtracecmd.so
%make_build prefix=%_prefix libdir=%_libdir V=1 \
	PYTHON_VERS=python3 \
	all_cmd \
	doc
%{?!_without_check:%{?!_disable_check:make test}}
chrpath --delete tracecmd/trace-cmd lib/trace-cmd/libtracecmd.so

%install
banner install
export CFLAGS="%optflags -D_GNU_SOURCE"
%makeinstall_std prefix=%_prefix libdir=%_libdir V=1 \
	PYTHON_VERS=python3 \
	install \
	install_libs \
	install_doc
# Duplicating man pages.
rm -rf %buildroot%_datadir/doc/libtracecmd-doc
# GUI script not belonging to the module, requiring gobject and gtk.
rm -f %buildroot%python3_sitelibdir/%name/event-viewer.py
# There are already man pages.
rm %buildroot%_datadir/doc/%name/*.html

%check
# Basic tests
%buildroot%_bindir/trace-cmd | grep 'version.%version.*(%version-%release'
%buildroot%_bindir/trace-cmd options

# Internal unit tests
export LD_LIBRARY_PATH=%buildroot%_libdir
vm-run --cpu=2 --append=schedstats=enable '
  set -xe
%ifnarch armh
  utest/trace-utest
%endif
  PATH=%buildroot%_bindir:$PATH
  trace-cmd record -p function -l exit'*' true
  trace-cmd report'

%files
%doc COPYING README
%_bindir/trace-cmd
%_datadir/bash-completion/completions/trace-cmd.bash
%_man1dir/*.1*
%_man5dir/*.5*

%files -n libtracecmd
%doc COPYING.LIB
%_libdir/libtracecmd.so.*

%files -n libtracecmd-devel
%doc LICENSES/*
%_includedir/trace-cmd
%_libdir/libtracecmd.so
%_libdir/pkgconfig/libtracecmd.pc
%_man3dir/*tracecmd*

%if_with python
%files -n python3-module-tracecmd
%doc Documentation/README.PythonPlugin
%_libdir/%name/python
%endif

%changelog
