Name: tuxpaint
Version: 0.9.32
Release: alt2

Summary: A drawing program for young children
Summary(ru_RU.UTF8): Простая детская программа для рисования

License: GPL-2.0
Group: Graphics
Url: http://www.tuxpaint.org/

Source: %name-%version.tar.gz
Source1: %name.desktop

# The databases in [/usr/local/share/applications, /usr/share/applications] could not be updated.
Patch0: desktop.patch
Patch1: tuxpaint-0.9.32-e2k-fix_bad_elf_symbol.patch
Patch2: tuxpaint-pango-cflags.patch

BuildRequires: libSDL2-devel libSDL2_image-devel libSDL2_mixer-devel libSDL2_gfx-devel
BuildRequires: libSDL2_ttf-devel libSDL2_pango-devel ImageMagick-tools xdg-utils
BuildRequires: libpng-devel zlib-devel gettext librsvg-devel libpaper-devel libfribidi-devel
BuildRequires: libimagequant-devel
BuildPreReq: gperf

%description
"Tux Paint" is a drawing program for young children.
It provides a simple interface and fixed canvas size,
and provides access to previous images using a thumbnail
browser (e.g., no access to the underlying file-system).

Unlike popular drawing programs like "The GIMP," it has a
very limited tool-set. However, it provides a much simpler
interface, and has entertaining, child-oriented additions
such as sound effects.

%description -l ru_RU.UTF8
"Tux Paint" является детской программой для рисования.
Она предоставляет простой интерфейс и фиксированый размер холста,
и позволяет просматривать изображениям, используя "thumbnail" браузер
(т.е., нет необходимости иметь доступ к основной файловой системе).

В отличие от популярных программ для рисования таких как "The GIMP",
она имеет очень ограниченный набор инструментов. Однако, это обеспечивает
намного более простой интерфейс, и имеет интересные, ориентированные на 
ребенка дополнения, типа звуковых эффектов.

Входит в состав GCompris. Также может использоваться отдельно

%package devel
Summary: Development shared library for %name
Group: Development/C
Requires: %name = %EVR

%description devel
Development shared library for %name

%prep
%setup
%patch0 -p2
# we can do it not only on e2k
%patch1 -p2
%patch2 -p1

subst "s|\$(PREFIX)/lib|%_libdir|g" Makefile
subst "s|< \$(PLUGIN_LIBS)|< \$(PLUGIN_LIBS) \$(SDL_LIBS) \$(PNG)|g" Makefile
sed -i '/^linux_ARCH_LINKS/s/\$(FRIBIDI_LIB)/\$(FRIBIDI_LIB) \$(PNG)/g' Makefile
sed -i 's|^\(CFLAGS\).*=\(.*\))|\1 = -g \2|' Makefile

%build
%make PREFIX=/usr MAGIC_PREFIX=%_libdir/%name/plugins

%install
%make install PREFIX=/usr \
    PKG_ROOT=%buildroot \
    MAGIC_PREFIX=%buildroot%_libdir/%name/plugins \
    X11_ICON_PREFIX=%buildroot%_datadir/pixmaps/ \
    GNOME_PREFIX=/usr \
    KDE_PREFIX="" \
    KDE_ICON_PREFIX=/usr/share/icons \
    DEVDOC_PREFIX=%buildroot%_defaultdocdir/%name-devel-%version

%find_lang %name

# Add tuxpaint.desktop
install -d %buildroot%_datadir/applications
cp -aRf %SOURCE1 %buildroot%_datadir/applications/

# Remove fonts (see ALT 25339)
rm -fv /usr/share/tuxpaint/fonts/Free*.ttf

# some chineese docs contains wrong shebang
rm -fv %buildroot%_datadir/doc/%name-%version/outdated/zh_tw/mkTuxpaintIM.py
rm -fv %buildroot%_datadir/%name/fonts/locale/zh_tw_docs/maketuxfont.py
rm -fv %buildroot%_datadir/%name/fonts/locale/zh_tw_docs/do_it.sh
# contains dependency on fontforge ALT#49865
rm -fv %buildroot%_datadir/%name/fonts/locale/zh_tw_docs/tuxpaintsubset.pe

# We dont need example library in docs
rm -fv %buildroot%_datadir/doc/%name-%version/*/tp_magic_example.so

%files -f %name.lang
%_bindir/tuxpaint*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.conf
%_sysconfdir/bash_completion.d/tuxpaint-completion.bash
%_libdir/%name

# docs files
%_docdir/%name-%version
%_man1dir/tuxpaint*

# data files
%_datadir/%name
%_datadir/applications/*
%_datadir/metainfo/org.tuxpaint.Tuxpaint.appdata.xml

# menu
%_datadir/pixmaps/*

%files devel
%_bindir/tp-magic-config
%_includedir/%name
%_man1dir/tp-magic-config*

%changelog
