%def_with docs

Name: txt2tags-python3
Version: 3.9
Release: alt1
Summary: Converts text files to HTML, XHTML, sgml, LaTeX, man...
License: GPL-2.0
Group: Text tools
URL: http://txt2tags.sourceforge.net/
# VCS: https://github.com/txt2tags/txt2tags
Source: txt2tags-%version.tar
BuildArch: noarch

Packager: Andrey Cherepanov <cas@altlinux.org>

BuildRequires(pre): rpm-build-python3
%if_with docs
BuildRequires: txt2tags
%endif

Conflicts: txt2tags

%description
Txt2tags is a generic text converter. From a simple text file with minimal
markup, it generates documents on the following formats: HTML, XHTML, sgml,
LaTeX, Lout, man, Magic Point (mgp), MoinMoin and Adobe PageMaker. Supports
heading, font beautifiers, verbatim, quote, link, lists, table and image.
There are GUI, Web and cmdline interfaces. It's a single Python script and
no external commands or libraries are needed.

%prep
%setup -n txt2tags-%version
# Set correct python2 executable in shebang
subst 's|#!.*python$|#!%__python3|' $(grep -Rl '#!.*python$' *)

%build
%python3_build
%if_with docs
pushd docs
./build-docs.sh
popd
%endif

%install
%python3_install
%find_lang txt2tags

%files -f txt2tags.lang
%doc CHANGELOG.md README.md extras/ samples/
%if_with docs
%doc docs/markup/*.html docs/rules/*.html docs/userguide/*.html
%endif
%_bindir/*
%python3_sitelibdir/*

%changelog
