Name: units
Version: 2.21
Release: alt1

Summary: A utility for converting amounts from one unit to another
License: GPLv3+
Group: Office
Url: https://www.gnu.org/software/units/units.html
# https://ftp.gnu.org/pub/gnu/%name/%name-%version.tar.gz
Source: %name-%version.tar
BuildRequires: libreadline-devel makeinfo rpm-build-python3

%description
Units converts an amount from one unit to another, or tells you what
mathematical operation you need to perform to convert from one unit to
another.  The units program can handle multiplicative scale changes as
well as conversions such as Fahrenheit to Celsius.

%prep
%setup
# remove generated files
rm parse.tab.c *.info*
# do not try to update currency.units from network during build
sed -i '/^install-support:/ s/ currency-units-update//' Makefile.in

%build
export PYTHON=%_bindir/python3
%configure
%make_build

%install
%makeinstall_std
ln -s units.1 %buildroot%_man1dir/units_cur.1

s=/usr/share/units/currency.units
t="$(readlink "%buildroot$s")"
case "$t" in
	/*) ln -fnrs "%buildroot$t" "%buildroot$s" ;;
esac

%check
%make_build -k check

%define _unpackaged_files_terminate_build 1

%files
%_bindir/*
%_datadir/%name/
/var/lib/%name/
%_infodir/*.info*
%_man1dir/*
%doc NEWS README

%changelog
