%def_enable snapshot
%def_enable check
%define _localstatedir %_var
%define git %nil
%define _group usbmux

Name: usbmuxd
Version: 1.1.1
Release: alt2

Summary: Daemon for communicating with Apple's iPod Touch and iPhone
Group: System/Servers
License: GPL-2.0 and GPL-3.0
Url: http://www.libimobiledevice.org/

Vcs: https://github.com/libimobiledevice/usbmuxd.git

%if_disabled snapshot
Source: http://www.libimobiledevice.org/downloads/%name-%version.tar.bz2
%else
Source: %name-%version.tar
%endif

%define plist_ver 2.6.0
%define usb_ver 1.0.9
%define imobiledevice_ver 1.3.0
%define glue_ver 1.0.0

BuildRequires: gcc-c++ cmake
BuildRequires: libplist-devel >= %plist_ver
BuildRequires: libusb-devel >= %usb_ver
BuildRequires: libimobiledevice-devel >= %imobiledevice_ver
BuildRequires: pkgconfig(libimobiledevice-glue-1.0) >= %glue_ver
BuildRequires: libudev-devel pkgconfig(systemd)

%description
usbmuxd (USB Multiplex Daemon) is a daemon used for communicating with
Apple's iPod Touch and iPhone devices. It allows multiple services on
the device to be accessed simultaneously.

%prep
%setup
echo %version > .tarball-version

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%check
%make check

%pre
/usr/sbin/groupadd -rf %_group ||:
/usr/sbin/useradd -M -r -s /dev/null -c "USB Multiplex Daemon" \
    -d %_localstatedir/empty -g %_group %_group &>/dev/null ||:

%files
%_sbindir/usbmuxd
%_udevrulesdir/39-%name.rules
%_unitdir/%name.service
%_man8dir/%name.*
%doc AUTHORS README* NEWS

%changelog
