%define _unpackaged_files_terminate_build 1
%define binary_name_gtk userpasswd-gtk
%define binary_name_adwaita userpasswd-adwaita
%define build_dir_gtk build_gtk
%define build_dir_adwaita build_adwaita

Name:    userpasswd
Version: 1.0.1
Release: alt1

Summary: Graphical utility for changing user password
License: GPLv3+
Group:   System/Configuration/Other
Url:     https://github.com/alxvmr/userpasswd

BuildRequires(pre): rpm-macros-cmake rpm-macros-alternatives
BuildRequires: cmake gcc
BuildRequires: pkgconfig(gobject-2.0) pkgconfig(gio-2.0) pkgconfig(json-glib-1.0)
BuildRequires: pkgconfig(gtk4)

# Common files with userpasswd.desktop and userpasswd-helper
Requires: userpasswd-common >= 1.0.0-alt1

Source0: %name-%version.tar

%description
A graphical utility to change your password

%package common
Summary: Desktop file and helper for userpasswd
Group: System/Configuration/Other
Conflicts: %name < 1.0.0-alt1
Conflicts: %name-gnome < 1.0.0-alt1
BuildRequires: pkgconfig(pam) pkgconfig(pam_misc)
# Due same as passwd PAM_SERVICE - /etc/pam.d/passwd
Requires: passwd

%description common
This package provides the file and helper needed to work with passwd

%package gnome
Summary: Graphical utility for changing user password in GNOME
Group: Other
BuildRequires: pkgconfig(libadwaita-1)
# Common files with userpasswd.desktop
Requires: userpasswd-common >= 1.0.0-alt1

%description gnome
A graphical password reset utility for GNOME that uses the Adwaita library for the interface.

%prep
%setup
mkdir -p %build_dir_adwaita
mkdir -p %build_dir_gtk

%build
%cmake -B %build_dir_gtk\
    -DUSE_ADWAITA=OFF
%cmake -B %build_dir_adwaita\
    -DUSE_ADWAITA=ON

cmake --build %build_dir_gtk -j%__nprocs
cmake --build %build_dir_adwaita -j%__nprocs

%install
DESTDIR=%buildroot cmake --install %build_dir_gtk
# rename userpasswd (gtk) -> userpasswd-gtk
mv %buildroot%_bindir/%name %buildroot%_bindir/%binary_name_gtk

DESTDIR=%buildroot cmake --install %build_dir_adwaita
# rename userpasswd (adwaita) -> userpasswd-gnome
mv %buildroot/%_bindir/%name %buildroot/%_bindir/%binary_name_adwaita

mkdir -p %buildroot/%_altdir
cat >%buildroot%_altdir/%binary_name_gtk <<EOF
%_bindir/%name    %_bindir/%binary_name_gtk    30
EOF

mkdir -p %buildroot/%_altdir
cat >%buildroot%_altdir/%binary_name_adwaita <<EOF
%_bindir/%name    %_bindir/%binary_name_adwaita    50
EOF

%files
%_bindir/%binary_name_gtk
%_altdir/%binary_name_gtk

%files gnome
%_bindir/%binary_name_adwaita
%_altdir/%binary_name_adwaita
%_datadir/metainfo/%name.metainfo.xml

%files common
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/*.svg
%attr(2711, root, shadow) %_libexecdir/userpasswd/helper
%lang(ru) %_datadir/locale/ru/LC_MESSAGES/%name.mo

%changelog
