%define git %nil
%define module_name	v4l2loopback
%define module_version	0.13.2
%define module_release	alt1
%define module_source_dir %nil

Name: %module_name
Version: %module_version
Release: %module_release
Summary: v4l2-loopback device
License: GPLv2
Group: System/Kernel and hardware
Url: https://github.com/umlaeute/v4l2loopback

BuildRequires: help2man

Source: %{module_name}-%version.tar
Patch: %{module_name}-%version-%release.patch

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

%package -n %module_name-utils
Version: %module_version
Release: %module_release
Group: System/Kernel and hardware
Summary: Linux %{module_name} - utilities

%package -n kernel-source-%module_name
Version: %module_version
Release: %module_release
Group: Development/Kernel
Summary: Linux %{module_name} - module sources
BuildArch: noarch

%description
This module allows you to create "virtual video devices". Normal (v4l2)
applications will read these devices as if they were ordinary video devices,
but the video will not be read from e.g. a capture card but instead it is
generated by another application. This allows you for instance to apply some
nifty video effects on your Skype video... It also allows some more serious
things (e.g. I've been using it to add streaming capabilities to an application
by the means of hooking GStreamer into the loopback devices).

%description -n %module_name-utils
Utilites for %module_name.

%description -n kernel-source-%module_name
%module_name - a kernel module to create V4L2 loopback devices sources.

%prep
%setup
%patch -p1
pushd utils
subst 's,CPPFLAGS\ +=\(.*\),CPPFLAGS += \1 $(RPM_OPT_FLAGS),' Makefile
popd

%build
make utils

%install
PREFIX=%_prefix DESTDIR=%buildroot make install-utils install-man
mkdir -p %buildroot%_udevrulesdir
mkdir -p %buildroot%_usrsrc/kernel/sources/
cp -a udev/*.rules %buildroot%_udevrulesdir/
mkdir kernel-source-%module_name-%module_version
cp -a *.{c,h} Kbuild Makefile* kernel-source-%module_name-%module_version/
tar -c kernel-source-%module_name-%module_version | bzip2 -c > \
	%buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%module_version.tar.bz2

%files -n %module_name-utils
%_bindir/*
%_man1dir/*
%_udevrulesdir/*.rules
%doc doc

%files -n kernel-source-%module_name
%attr(644,root,root) %_usrsrc/kernel/sources/kernel-source-%module_name-%version.tar.bz2

%changelog
