%define majver 3.1

Name: volk
Version: %majver.2
Release: alt1

Summary: Vector-Optimized Library of Kernels
License: LGPL-3.0-or-later
Group: Development/C++

Url: http://libvolk.org/
Source0: %name-%version.tar
Source1: cpu_features.tar
Patch2000: %name-e2k.patch

BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++ cmake
BuildRequires: liborc-devel orc
BuildRequires: boost-filesystem-devel
#BuildRequires: git-core

# python subpackage
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-six
BuildRequires: python3-module-mako

%define descr \
VOLK:\
- is the Vector-Optimized Library of Kernels;\
- is a free library, currently offered under the LGPL-3.0 license;\
- provides an abstraction of optimized math routines targetting\
  several SIMD processors.

%description
%descr

%package -n lib%name
Group: Development/C++
Summary: Vector-Optimized Library of Kernels

%description -n lib%name
%descr

This package contains the shared library for %name.

%package -n lib%name-devel
Summary: Vector-Optimized Library of Kernels
Group: Development/C++
Requires: lib%name = %EVR

%description -n lib%name-devel
%descr

This package contains the headers to build software against %name.

%package -n python3-module-%name
Summary: The Python 3 bindings for VOLK
Group: Development/Python3
Requires: lib%name = %EVR

%description -n python3-module-%name
%descr

This package contains Python 3 module for VOLK.

%prep
%setup -a 1
%ifarch %e2k
sed -i "/incompatible-pointer-types/d" CMakeLists.txt
%patch2000 -p1
%add_optflags -mno-sse4.2
%endif

%build
# workaround, the code is not yet compatible with the strict-aliasing
%add_optflags -fno-strict-aliasing
%cmake \
	-DGR_PYTHON_DIR=%python3_sitelibdir \
	-DPYTHON_EXECUTABLE=%__python3

%cmake_build

%install
%cmake_install

# Not needed
rm -f %buildroot%_bindir/list_cpu_features
rm -f %buildroot%_libdir/libcpu_features.a
rm -fr %buildroot%_libdir/cmake/CpuFeatures

%files
%_bindir/*
%doc COPYING README.md

%files -n lib%name
%_libdir/lib%name.so.%majver
%_libdir/lib%name.so.%version

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%_libdir/cmake/%name

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
