%define libname libwim

Name: wimlib
Version: 1.14.4
Release: alt1

Summary: Library to extract, create, modify, and mount WIM files
License: GPLv3+
Group: System/Libraries

Url: https://wimlib.net/
Source: https://wimlib.net/downloads/wimlib-%version.tar


BuildRequires: patchelf
BuildRequires: libattr-devel libntfs-3g-devel libssl-devel libxml2-devel
BuildRequires: libfuse3-devel

%description
wimlib is a C library for creating, extracting, modifying, and mounting
files in the Windows Imaging Format (WIM files).  It is similar to
Microsoft's WIMGAPI but is designed for both UNIX and Windows.

%package -n %libname
Summary: Library to extract, create, modify, and mount WIM files
Group: System/Libraries

%description -n %libname
wimlib is a C library for creating, extracting, modifying, and mounting
files in the Windows Imaging Format (WIM files).  It is similar to
Microsoft's WIMGAPI but is designed for both UNIX and Windows.

%package -n %libname-devel
Summary: Development files for wimlib
Group: Development/Other
Requires: %libname = %version-%release

%description -n %libname-devel
Development files for wimlib.

%package -n wimtools
Summary: Tools to create, extract, modify, and mount WIM files
Group: File tools
Requires: %libname = %version-%release
%ifarch x86_64 %ix86
Requires: syslinux
%endif

%description -n wimtools
Tools to create, extract, modify, and mount files in the
Windows Imaging Format (WIM files).  These files are normally
created by using the `imagex.exe' utility on Windows,
but this package contains a free implementation of ImageX called
"wimlib-imagex" that is designed to work on both UNIX and Windows.

%prep
%setup

%build
# helps with rpath
#autoreconf

%configure \
       --disable-static \
       --disable-rpath  \
       --with-libcrypto \
       --with-ntfs-3g   \
       --with-fuse      \
       --enable-xattr
%make_build

%install
%makeinstall_std
patchelf --remove-rpath %buildroot%_bindir/wim*

%check
:>tests/test-imagex-ntfs # this one fails
make check

%files -n %libname
%doc README.md NEWS.md
%_libdir/libwim.so.*

%files -n wimtools
%_bindir/wim*
%_bindir/mkwinpeimg
%_man1dir/*

%files -n %libname-devel
%_libdir/libwim.so
%_includedir/wimlib.h
%_pkgconfigdir/wimlib.pc

%changelog
