%define _unpackaged_files_terminate_build 1
%def_enable snapshot

%define _libexecdir %_prefix/libexec
%define ver_major 0.49
%define beta %nil

%define _name phosh
# phrosh portal
%define _name1 phrosh
%define name1 xdg-desktop-portal-%_name1

%def_enable check

%def_disable bootstrap

Name: xdg-desktop-portal-%_name
Version: %ver_major.0
Release: alt1%beta

Summary: Phosh Desktop Portal
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://gitlab.gnome.org/guidog/xdg-desktop-portal-phosh

Vcs: https://gitlab.gnome.org/guidog/xdg-desktop-portal-phosh.git

%if_disabled snapshot
Source: https://gitlab.gnome.org/guidog/xdg-desktop-portal-phosh/-/archive/v%version/%name-v%version%beta.tar.gz
%else
Source: %name-%version%beta.tar
%endif
Source1: %name-%version%beta-cargo.tar

%define xdg_desktop_portal_ver 1.19.1
%define adw_ver 1.6
%define gsds_ver 47
%define pfs_ver 0.0.4

Requires: xdg-desktop-portal >= %xdg_desktop_portal_ver

BuildRequires(pre): rpm-macros-meson rpm-build-systemd
BuildRequires: meson rust-cargo
BuildRequires: pkgconfig(libadwaita-1) >= %adw_ver
BuildRequires: pkgconfig(libpfs-0)
BuildRequires: pkgconfig(gnome-desktop-4)
BuildRequires: pkgconfig(xdg-desktop-portal) >= %xdg_desktop_portal_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver

%description
A backend implementation for xdg-desktop-portal that is using
GTK/GNOME/Phosh to provide interfaces that aren't provided by the GTK
portal.

%prep
%setup -n %name-%{?_disable_snapshot:v}%version%beta %{?_disable_bootstrap:-a1}
%{?_enable_bootstrap:
[ -d .cargo ] || mkdir .cargo
cargo vendor | sed 's/^directory = ".*"/directory = "vendor"/g' > .cargo/config.toml
tar -cf %_sourcedir/%name-%version%beta-cargo.tar .cargo/ vendor/}

%build
%meson
%meson_build

%install
%meson_install
%find_lang %name

%check
%__meson_test

%files -f %name.lang
%_libexecdir/%name
%_desktopdir/%name.desktop
%_datadir/dbus-1/services/org.freedesktop.impl.portal.desktop.%_name.service
%_datadir/xdg-desktop-portal/portals/%_name.portal
%_userunitdir/%name.service

%_libexecdir/%name1
%_desktopdir/%name1.desktop
%_datadir/dbus-1/services/org.freedesktop.impl.portal.desktop.%_name1.service
%_datadir/xdg-desktop-portal/portals/%_name1.portal
%_userunitdir/%name1.service

%doc NEWS README*


%changelog
