Name: xfce4-session
Version: 4.20.3
Release: alt1

Summary: Session manager for Xfce desktop environment
Summary (ru): Менеджер сессий для окружения рабочего стола Xfce
License: GPLv2+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/xfce/xfce4-session/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/xfce4-session.git
Source: %name-%version.tar
Source1: xfce.wmsession
Source2: xfce4-xscreensaver.desktop

Patch: %name-%version-%release.patch

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util-devel >= 4.19.2 libxfconf-devel >= 4.18.0 libxfce4ui-gtk3-devel >= 4.18.4
BuildRequires: libxfce4windowing-devel >= 4.19.2
# For gdk-pixbuf-csource
BuildRequires: libgdk-pixbuf-devel
BuildRequires: libpolkit-devel
BuildRequires: libX11-devel iceauth libICE-devel libSM-devel libwnck3-devel
BuildRequires: libgtk-layer-shell-devel

Requires: wm-common-freedesktop
Requires: xfce4-about

Obsoletes: xfce-utils < %version
Obsoletes: libxfsm < %version-%release

Conflicts: xfce4-screensaver < 0.1.10-alt1
# libxfce4windowing >= 4.19.6 breaks API/ABI whithout soname change
Conflicts: libxfce4windowing < 4.19.6

%define _unpackaged_files_terminate_build 1

%description
%name is the session manager for the Xfce desktop environment.

%description -l ru
Данный пакет содержит в себе менеджер сессий, используемый в окружении
рабочего стола Xfce.

%package wayland
Summary: Wayland session for Xfce desktop environment
Summary (ru): Сессия wayland для окружения рабочего стола Xfce
Group: Graphical desktop/XFce
Requires: %name = %EVR
Requires: labwc-base
Requires: xorg-xwayland

%description wayland
Wayland session for Xfce desktop environment.

%description -l ru
Данный пакет содержит сессию Wayland для окружения рабочего
стола Xfce.

%prep
%setup
%patch -p1

%build
%xfce4reconf
%configure \
	--disable-static \
	--with-backend=linux \
	--enable-x11 \
	--enable-wayland \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
install -Dm0644 %SOURCE1 %buildroot%_x11sysconfdir/wmsession.d/10Xfce4
install -Dm0644 %SOURCE2 %buildroot%_sysconfdir/xdg/autostart/xfce4-xscreensaver.desktop
%find_lang %name

%files -f %name.lang
%doc README.md NEWS AUTHORS
%doc doc/FAQ doc/README.Kiosk
%_x11sysconfdir/wmsession.d/*
%config(noreplace) %_sysconfdir/xdg/xfce4/*
%config(noreplace) %_sysconfdir/xdg/autostart/*.desktop
%_sysconfdir/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-session.xml
%_bindir/*
%dir %_libdir/xfce4/session
%_libdir/xfce4/session/xfsm-*
%_desktopdir/*
%_iconsdir/hicolor/*/*/*
%_mandir/man?/*
%_datadir/xsessions/*.desktop
%_datadir/polkit-1/actions/*.policy
%_datadir/xdg-desktop-portal/xfce-portals.conf

%files wayland
%_datadir/wayland-sessions/xfce-wayland.desktop
%_datadir/xfce4/labwc/

%changelog
