Name: xfce4-weather-plugin
Version: 0.12.0
Release: alt1

Summary: Weather plugin for the Xfce panel
License: GPL-2.0+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/panel-plugins/%name
Packager: Xfce Team <xfce@packages.altlinux.org>
Vcs: https://gitlab.xfce.org/panel-plugins/xfce4-weather-plugin.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): meson
BuildRequires: rpm-build-xfce4 xfce4-dev-tools
BuildRequires: libxfce4util-devel libxfce4ui-gtk3-devel libxfce4panel-gtk3-devel >= 4.16.0
BuildRequires: libxfconf-devel
BuildRequires: libgio-devel
BuildRequires: libjson-c-devel
BuildRequires: libxml2-devel libupower-devel
%if %{defined _priority_distbranch} %{?_priority_distbranch:&& %_priority_distbranch != p9 && %_priority_distbranch != p10}
BuildRequires: libsoup3.0-devel
%else
BuildRequires: libsoup-devel
%endif

Requires: xfce4-panel

%define _unpackaged_files_terminate_build 1

%define geonames_username altlinux

%description
%name is the plugin for the Xfce panel, that display weather information
using forecast data provided by met.no.

%prep
%setup
%patch -p1

%build
%meson \
	-Dupower-glib=enabled \
	-Dgeonames-username=%geonames_username

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%doc README AUTHORS NEWS
%_libdir/xfce4/panel/plugins/*
%_datadir/xfce4/weather
%_datadir/xfce4/panel/plugins/*.desktop
%_iconsdir/hicolor/*/apps/*.*

%changelog
