Name: xfdashboard
Version: 1.1.0
Release: alt1

Summary: A Gnome shell like dashboard for Xfce
License: GPL-2.0+
Group: Graphical desktop/XFce
Url: https://docs.xfce.org/apps/xfdashboard/start

Vcs: https://gitlab.xfce.org/apps/xfdashboard.git
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

BuildRequires(pre): meson rpm-macros-meson >= 1.3.1-alt1
BuildRequires(pre): rpm-build-xdg
BuildRequires: rpm-build-xfce4 >= 0.1.0 xfce4-dev-tools
BuildRequires: libxfconf-devel >= 4.14.0 libgarcon-devel libxfce4util-devel libxfce4ui-gtk3-devel
BuildRequires: libgtk+3-devel libwnck3-devel libclutter-devel
BuildRequires: libXinerama-devel

%define _unpackaged_files_terminate_build 1

%description
xfdashboard provides a GNOME shell dashboard like interface for use with
Xfce desktop. It can be configured to run to any keyboard shortcut and
when executed provides an overview of applications currently open
enabling the user to switch between different applications. The search
feature works like Xfce's app finder which makes it convenient to search
for and start applications.

%package -n lib%name
Summary: Shared libraries for %name
Group: Graphical desktop/XFce

%description -n lib%name
This package contains libraries for %name.

%package -n lib%name-devel
Summary: Devel files for %name
Group: Graphical desktop/XFce
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains development files required to build
%name-based software.

%prep
%setup
%patch -p1

%build
%meson

%meson_build -v

%install
%meson_install
%find_lang %name

%files -f %name.lang
%_bindir/%{name}*
%_libdir/%name/
%_xdgconfigdir/autostart/*.desktop
%_datadir/metainfo/*.xml
%_desktopdir/*.desktop
%_iconsdir/hicolor/*/*/*.*
%_datadir/themes/%{name}*/
%_datadir/%name/

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_pkgconfigdir/*.pc
%_includedir/%name/
%_libdir/*.so

%changelog
