Name:         xfig
Version:      3.2.9
Release:      alt2

Summary:      An X Window System tool for drawing basic vector graphics.
Group:        Graphics
URL:          https://sourceforge.net/projects/mcj/
License:      Freeware

Packager:     Vladislav Zavjalov <slazav@altlinux.org>
Source0:       %name-%version.tar
Source1:      xfig16.png
Source2:      xfig32.png
Source3:      xfig48.png
Source4:      xfig.sh
Source5:      xfig.alt.desktop
Patch1:       0001-revert-10pt-search-tolerance-back-to-4pt.patch
Patch2:       0002-w_library.c-fix-error-message.patch
Patch3:       0001-app-defaults-metric-nosplash.patch

Requires:     transfig = %version fonts-ttf-PT /usr/bin/gs netpbm

BuildPreReq:  libXpm-devel libXt-devel libXmu-devel libXaw-devel
BuildPreReq:  libpng-devel libjpeg-devel libXi-devel libXp-devel
BuildPreReq:  libtiff-devel libgs-devel libXft-devel
BuildPreReq:  libXaw3d-devel >= 1.5e
BuildRequires: transfig = %version

%description
Xfig is an X Window System tool for creating basic vector graphics,
including arcs, ellipses, bezier curves, lines, rulers and more.
The resulting graphics can be saved, printed on PostScript printers 
or converted to a variety of other formats (e.g., X11 bitmaps, CGM,
Encapsulated PostScript, LaTeX).

You should install xfig if you need a program to create vector graphics.

%package -n xfig-libs
Summary:  XFig image libraries
Group:    Graphics
BuildArch: noarch

%description -n xfig-libs
Library of FIG images

%package -n xfig-docs
Summary:  XFig documentation
Group:    Graphics
BuildArch: noarch

%description -n xfig-docs
XFig documentation

%prep
%setup -q
%patch1 -p2
%patch2 -p2
%patch3 -p2

%build
%autoreconf
%configure --with-appdefaultdir=%_x11appconfdir
%make

%install
%makeinstall_std
install -D -m 644 %SOURCE1 %buildroot/%_miconsdir/xfig.png
install -D -m 644 %SOURCE2 %buildroot/%_niconsdir/xfig.png
install -D -m 644 %SOURCE3 %buildroot/%_liconsdir/xfig.png
install -D -m 755 %SOURCE4 %buildroot/%_bindir/xfig.sh
install -D -m 644 %SOURCE5 %buildroot/%_desktopdir/xfig.desktop

%files
%_bindir/xfig
%_bindir/xfig.sh
%_man1dir/*
%_x11appconfdir/*
%_desktopdir/xfig.desktop
%_liconsdir/xfig.png
%_niconsdir/xfig.png
%_miconsdir/xfig.png
%_pixmapsdir/xfig.png
%dir /usr/share/xfig/
/usr/share/xfig/CompKeyDB

%files -n xfig-libs
/usr/share/xfig/Libraries

%files -n xfig-docs
/usr/share/doc/xfig

%changelog
