%define py_name youtube_dl
# snapshot does not have the man page
%def_with snapshot

Name: youtube-dl
Version: 2023.09.27
Release: alt1

Summary: Download videos from YouTube
License: Public domain
Group: Networking/File transfer
Url: http://youtube-dl.org

Source0: %name-%version.tar

BuildArch: noarch

Requires: python3-module-%py_name = %EVR

# Automatically added by buildreq on Fri Apr 08 2016
# optimized out: python-base python-devel python-modules python-modules-compiler python-modules-ctypes python-modules-email python3 python3-base
BuildRequires: python-module-setuptools python3-dev python3-module-setuptools
BuildRequires(pre): rpm-build-python3
%if_with snapshot
BuildRequires: /usr/bin/sphinx-build
%endif

%description
Youtube-dl is a small command-line program to download videos
from YouTube.com.

%package -n python-module-%py_name
Group: Development/Python
Summary: Python module for youtube-dl
Conflicts: youtube-dl < 2016.04.06-alt1

%description -n python-module-%py_name
Youtube-dl is a small command-line program to download videos
from YouTube.com.

This package contains Python module.

%package -n python3-module-%py_name
Group: Development/Python
Summary: Python 3 module for youtube-dl

%description -n python3-module-%py_name
Youtube-dl is a small command-line program to download videos
from YouTube.com.

This package contains Python 3 module.

%prep
%setup -c
for py in py2 py3; do
	cp -a %name-%version $py
done

%build
cd py2
	%python3_build
%if_with snapshot
	make -C docs man
%endif
cd -

cd py3
	%python_build
cd -

%install
cd py3
	%python_install
cd -

cd py2
	%python3_install
%if_with snapshot
	install -D -m644 docs/_build/man/youtube-dl.1 %buildroot%_man1dir/youtube-dl.1
%endif
cd -

%files
%_bindir/youtube-dl
%_man1dir/youtube-dl.1.*

%files -n python-module-%py_name
%python_sitelibdir/%py_name
%python_sitelibdir/%py_name-*.egg-info

%files -n python3-module-%py_name
%python3_sitelibdir/%py_name
%python3_sitelibdir/%py_name-*.egg-info

%changelog
