%define _libexecdir %_prefix/libexec
%global _localstatedir %_var

Name: zfs
Version: 2.3.1
Release: alt1
Summary: ZFS on Linux
License: CDDL-1.0
Group: System/Kernel and hardware
URL: https://zfsonlinux.org/
VCS: https://github.com/openzfs/zfs
Conflicts: fuse-zfs

Source0: %name-%version.tar
Source1: gitrevision.h
Patch1: zfs-2.2.2-import-by-disk-id.patch

BuildRequires: libblkid-devel libssl-devel libudev-devel libuuid-devel python3-devel zlib-devel rpm-build-kernel libtirpc-devel

%description
This package contains the ZFS command line utilities

%package utils
Summary: Native OpenZFS management utilities for Linux
Group: System/Kernel and hardware
Provides: spl-utils = %version-%release splat = %version-%release
Obsoletes: spl-utils < %version-%release
Conflicts: fuse-zfs

%description utils
This package provides the zpool and zfs commands that are used to
manage OpenZFS filesystems.

%package zed
Summary: OpenZFS Event Daemon
Group: System/Kernel and hardware

%description zed
This package adds OpenZFS to the system initramfs with a hook
for the initramfs-tools infrastructure.

%package -n lib%name
Summary: ZFS shared libraries
Group: System/Libraries

%description -n lib%name
This package contains ZFS shared libraries.

%package -n lib%name-devel
Summary: ZFS development files
Group: Development/C

%description -n lib%name-devel
This package contains ZFS development files.

%package -n kernel-source-%name
Summary: ZFS modules sources for Linux kernel
Group: Development/Kernel
BuildArch: noarch
Provides: kernel-src-%name = %version-%release

%description -n kernel-source-%name
This package contains ZFS modules sources for Linux kernel.

%prep
%setup -q
%patch1 -p1
sed -i 's|datarootdir|libdir|' lib/libzfs/Makefile.am
install -m0644 %SOURCE1 include/zfs_gitrev.h

%build
%autoreconf
%configure \
	--sbindir=/usr/sbin \
	--libexecdir=%_libexecdir \
	--with-config=user \
	--with-udevdir=/lib/udev \
	--with-udevruledir=%_udevrulesdir \
	--enable-systemd \
	--with-systemdunitdir=%_unitdir \
	--with-systemdpresetdir=%_unitdir-preset \
	--with-systemdgeneratordir=/lib/systemd/system-generators \
	--disable-sysvinit \
	--with-gnu-ld \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot pkgdatadir=%_datadir/doc/%name-utils-%version/examples modulesloaddir=%_sysconfdir/modules-load.d install
install -pDm0644 %SOURCE0 %kernel_srcdir/%name-%version.tar
# add the header with git revision to tarball for kernel-source
tar --append --file=%kernel_srcdir/%name-%version.tar -- ../%name-%version/include/zfs_gitrev.h

gzip %kernel_srcdir/%name-%version.tar
install -m0644 COPYRIGHT LICENSE %buildroot%_datadir/doc/%name-utils-%version/

#remove binary file from docdir:
rm -f %buildroot%_docdir/%name-utils-%version/examples/zed_fd_spill-zedlet

touch %buildroot%_sysconfdir/%name/zpool.cache
mkdir -p %buildroot%_sysconfdir/{modprobe.d,dfs}
touch %buildroot%_sysconfdir/dfs/sharetab
cat << __EOF__ > %buildroot%_sysconfdir/modprobe.d/zfs.conf
#options zfs zfs_autoimport_disable=0
__EOF__

rm -fr %buildroot%_datadir/zfs

%post utils
if [ $1 -eq 1 ] ; then
	/sbin/systemctl preset \
		zfs-import-cache.service \
		zfs-import-scan.service \
		zfs-mount.service \
		zfs-import.target \
		zfs.target \
		>/dev/null 2>&1 || :
fi

%preun utils
if [ $1 -eq 0 ] ; then
	/sbin/systemctl disable \
		zfs-import-cache.service \
		zfs-import-scan.service \
		zfs-mount.service \
		zfs-import.target \
		zfs.target \
		>/dev/null 2>&1 || :
fi

%post zed
if [ $1 -eq 1 ] ; then
	/sbin/systemctl preset \
		zfs-zed.service \
		>/dev/null 2>&1 || :
fi

%preun zed
if [ $1 -eq 0 ] ; then
	/sbin/systemctl disable \
		zfs-zed.service \
		>/dev/null 2>&1 || :
fi

%files utils
%_datadir/doc/%name-utils-%version
%dir %_sysconfdir/%name
%ghost %_sysconfdir/%name/zpool.cache
%dir %_sysconfdir/dfs
%ghost %_sysconfdir/dfs/sharetab
%exclude %_unitdir/zfs-zed.service
%config(noreplace) %_sysconfdir/modprobe.d/zfs.conf
%dir %_sysconfdir/zfs/zpool.d
%config(noreplace) %_sysconfdir/zfs/zpool.d/*
%config(noreplace) %_sysconfdir/sysconfig/zfs
%config(noreplace) %_sysconfdir/sudoers.d/zfs
%_sysconfdir/zfs/zfs-functions
%_sysconfdir/zfs/*.example
%_sysconfdir/modules-load.d/%name.conf
%_sysconfdir/bash_completion.d/zfs
%_sysconfdir/bash_completion.d/zpool
%_unitdir/*.service
%_unitdir/*.timer
%_unitdir/*.target
%_unitdir-preset/50-zfs.preset
/sbin/mount.zfs
/lib/systemd/system-generators/zfs-mount-generator
/lib/udev/*_id
%_udevrulesdir/*.rules
%exclude %_sbindir/zed
%_sbindir/*
%_bindir/*
%_man1dir/*.1*
%_man4dir/*.4*
%_man5dir/*.5*
%_man7dir/*.7*
%_man8dir/*.8*
%exclude %_man8dir/zed.8*

%files zed
%dir %_sysconfdir/%name/zed.d
%_sysconfdir/%name/zed.d/*.sh
%_sysconfdir/%name/zed.d/zed.rc
%_sysconfdir/%name/zed.d/zed-functions.sh
%_unitdir/zfs-zed.service
%_sbindir/zed
%_libexecdir/zfs
%_man8dir/zed.8*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_pkgconfigdir/*.pc
%_libdir/*.so

%files -n kernel-source-%name
%_usrsrc/kernel

%changelog
