%define zincati_user         zincati
%define zincati_group        %zincati_user
%define zincati_home         %_localstatedir/%zincati_user

%define zincati_confdir1     %_libexecdir/%name/
%define zincati_confdir2     %_sysconfdir/%name/
%define zincati_dbus_systemd /usr/share/dbus-1/system.d/

%define zincati_bindir       %{_prefix}/libexec/

Name:     zincati
Version:  0.0.22
Release:  alt7

Summary:  An auto-update agent for ALT Container OS hosts.
License:  Apache-2.0
Group:    Development/Tools
Url:      https://github.com/coreos/zincati

Source:   %name-%version.tar
Patch1:   %name-%version-%release.patch
Patch3500: nix-loongarch64.patch

BuildRequires(pre): rpm-build-rust
BuildRequires: openssl-devel
BuildRequires: /proc
BuildRequires: cargo-vendor-checksum diffstat

%description
%summary

%prep
%setup
%patch1 -p1
%patch3500 -p1
diffstat -l -p1 < %PATCH3500 | sed -re 's@vendor/@@' | xargs -r cargo-vendor-checksum -f

%build
%rust_build

%install
%rust_install -t %zincati_bindir
mkdir -p %buildroot{%zincati_confdir1/config.d,%zincati_confdir2/config.d,%zincati_dbus_systemd,%_unitdir}
install dist/config.d/* %buildroot%zincati_confdir1/config.d
install -Dm 444 dist/systemd/system/zincati.service %buildroot%_unitdir
install -Dm 755 dist/tmpfiles.d/zincati.conf  %buildroot%_tmpfilesdir/zincati.conf
install dist/dbus-1/system.d/org.coreos.zincati.conf %buildroot%zincati_dbus_systemd
install -Dm 755 alt-ostree %buildroot%_bindir/alt-ostree
ln -s alt-ostree %buildroot%_bindir/rpm-ostree
install -d -m 0755 %buildroot%zincati_home
install -d -m 0755 %buildroot/var/log/alt-ostree

%pre
groupadd -r -f %zincati_group >/dev/null 2>&1 ||:
useradd -g %zincati_group -G root,wheel -c 'Zincati user for auto-updates' -M -d %zincati_home -s /dev/null -r -l %zincati_user >/dev/null 2>&1 ||:

%files
%zincati_bindir/*
%_bindir/*
%zincati_dbus_systemd/*
%_unitdir/*
%_tmpfilesdir/*
%attr(-,%zincati_user,%zincati_group) %dir %zincati_home
%attr(-,%zincati_user,%zincati_group) %dir /var/log/alt-ostree
%zincati_confdir1
%zincati_confdir2
%doc *.md

%changelog
