Name: alternatives
Version: 0.5.1
Release: alt1

Summary: alternatives support
License: GPLv2+
Group: System/Base
# http://alternatives.sourceforge.net
Url: http://git.altlinux.org/gears/a/alternatives.git
BuildArch: noarch

Source: %name-%version.tar

# for filetrigger
Requires: grep

Requires: getopt mktemp

Provides: %_sysconfdir/%name/packages.d
Provides: lib%name = %version, lib%name-devel = %version, lib%name-devel-static = %version
Obsoletes: lib%name, lib%name-devel, lib%name-devel-static

#utilities that use alternatives
Conflicts: gcc-common <= 1.4.3-alt1, gnupg2 <= 1.9.7-alt2

# due to PackagedFiles()
BuildPreReq: rpm >= 4.0.4-alt87

# due to versioned paths
Conflicts: rpm-build < 4.0.4-alt93

# due to %_sbindir/update-alternatives
Conflicts: update-alternatives

BuildPreReq: libshell help2man
Requires: rpm-macros-%name = %version-%release

%description
Alternatives subsystem. This package contains common utilites for it.

%package -n rpm-macros-%name
Summary: Set of RPM macros for packaging %name-based applications
Group: Development/Other
Conflicts: alternatives < 0.4

%description -n rpm-macros-%name
Set of RPM macros for packaging %name-based applications for ALT Linux.
Install this package if you want to create RPM packages that use %name.

%prep
%setup -n %name-%version

%build
%install
mkdir -p %buildroot%_sysconfdir/%name/{auto,packages.d,links}
touch %buildroot%_sysconfdir/%name/manual
%makeinstall

mkdir -p %buildroot%_rpmmacrosdir
cat >%buildroot%_rpmmacrosdir/%name<<EOF
%%_altdir %%([ ! -f %_datadir/%name/functions ])%_sysconfdir/%name/packages.d
%%force_update_alternatives [ -x %_bindir/%name-update ] && %_bindir/%name-update ||:
EOF

install -pD -m755 alternatives.prov %buildroot%_rpmlibdir/alternatives.prov
install -pD -m755 alternatives.prov.files %buildroot%_rpmlibdir/alternatives.prov.files
install -pD -m755 alternatives.filetrigger %buildroot%_rpmlibdir/alternatives.filetrigger

# /usr/sbin/alternatives-update is still used by the following packages:
# java-1.6.0-openjdk-headless-1.6.0.41-alt6
# java-1.7.0-openjdk-headless-1.7.0.181-alt1_2.6.14.8jpp8
# java-1.8.0-openjdk-headless-1.8.0.151-alt1_5.b12jpp8
# php5-5.6.38-alt1.S1
mkdir -p %buildroot%_sbindir
ln -rs %buildroot%_bindir/alternatives-update %buildroot%_sbindir/

# https://bugzilla.altlinux.org/36073
ln -s /bin/true %buildroot%_sbindir/update-alternatives

%files
%doc README TODO
%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/auto
%dir %_sysconfdir/%name/links
%dir %_sysconfdir/%name/packages.d
%ghost %config(noreplace,missingok) %_sysconfdir/%name/manual
%_bindir/*
%_sbindir/alternatives-update
%_sbindir/update-alternatives
%_datadir/%name
%_man1dir/*
%_rpmlibdir/alternatives.prov
%_rpmlibdir/alternatives.prov.files
%_rpmlibdir/alternatives.filetrigger
%exclude %_rpmmacrosdir/*

%files -n rpm-macros-%name
%_rpmmacrosdir/*

%changelog
