Name: asymptote
Version: 2.68
Release: alt1

Summary: Descriptive vector graphics language

Group: Sciences/Other
License: GPL
Url: http://asymptote.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/vectorgraphics/asymptote/archive/%version.tar.gz
Source: %name-%version.tar

Patch: asymptote-1.91-alt-DSO.patch
Patch1: asymptote-1.91-alt-glibc-2.16.patch
Patch2: asymptote-2.28-alt-gsl1.16.patch

BuildRequires: flex gcc-c++ libfftw3-devel libgsl-devel libreadline-devel libtirpc-devel zlib-devel
BuildRequires: libglm-devel
BuildRequires: libfreeglut-devel
BuildRequires: libcurl-devel

BuildRequires: libgc-devel >= 7.4.2

BuildRequires(pre): rpm-build-tex rpm-build-python3
BuildRequires: /proc
BuildRequires: texlive-collection-latexrecommended ghostscript-utils
BuildRequires: python3-module-PyQt5
BuildRequires: python3-module-mpl_toolkits python3-module-yieldfrom
# explicitly added texinfo for info files
BuildRequires: texinfo
BuildRequires: texi2dvi

%add_python3_path %_datadir/%name/GUI/
%add_python3_lib_path %_datadir/%name/GUI/
%add_python3_req_skip configs

%description
Asymptote is a powerful descriptive vector graphics language for technical
drawings, inspired by MetaPost but with an improved C++-like syntax.
Asymptote provides for figures the same high-quality level of typesetting
that LaTeX does for scientific text.

%package doc
Summary: Documentation and examples for %name
Group: Documentation
BuildArch: noarch

%description doc
Documentation and examples for %name.

%prep
%setup
%__subst "s|/lib |/%_lib |" configure.ac
%__subst "s|-lgc |-lgc -lgccpp |" configure.ac
#patch0 -p2
#patch1 -p2
#patch2 -p2
# some incompatibilities?
sed -i "s|@printindex cp||g" doc/%name.texi

# sure we do not using internal libgc
rm -fv *.tar.gz

%build
%autoreconf
%configure --with-docdir=%_docdir/%name-doc-%version \
	--with-latex=%_texmfmain/tex/latex \
	--with-context=%_texmfmain/tex/context/third \
	--enable-gc=system \
	--enable-gsl
%make_build

%install
%makeinstall_std
# TODO: conflicts with  texlive-collection-basic-2018-alt1_5.noarch
mv %buildroot%_man1dir/asy.1 %buildroot%_man1dir/asy-asymptote.1

%files
%doc BUGS LICENSE README TODO
%_bindir/asy
%_bindir/xasy
%_datadir/%name/
%_texmfmain/tex/latex/%name/
%_texmfmain/tex/context/third/%name/
%_man1dir/*.1*

%files doc
%_docdir/%name-doc-%version/
%_infodir/*.info*
%_infodir/%name/*.info*

%changelog
