Name: bluefish
Version: 2.2.11
Release: alt1

Summary: A GTK3 web development application for experienced users

Serial: 2

Url: http://bluefish.openoffice.nl
License: GPL-3.0-or-later
Group: Editors

Source: %name-%version.tar.bz2

# Fedora patchs
# Avoid potential aliasing issues in zencoding plugin
Patch0: bluefish-2.2.10-strict-aliasing.patch

# Avoid use of /usr/bin/env in shipped scripts
# Also change /usr/bin/python → /usr/bin/python2 (for now)
Patch1: bluefish-2.2.11-shellbang.patch

# Strip all python content if we don't have Python
Patch2: bluefish-2.2.11-no-python.patch

Requires: bluefish-common = %serial:%version-%release

BuildRequires: intltool
BuildRequires: libgtk+3-devel
BuildRequires: libgucharmap-devel
BuildRequires: libxml2-devel
BuildRequires: libenchant-devel
BuildRequires: libappstream-glib

%description
Bluefish is a powerful editor for experienced web designers and programmers.
Bluefish supports many programming and markup languages, but it focuses on
editing dynamic and interactive websites

%package common
Summary: Common files for Bluefish
Group: Editors
BuildArch: noarch
Serial: 2

%description common
Bluefish is a powerful editor for experienced web designers and programmers.
These are common files.

%prep
%setup
#for N in src/plugin_*/po; do ln -s /usr/share/intltool/Makefile.in.in $N/;done
#for N in src/plugin_*/po; do test -r $N/Makefile.in.in && echo $N || ln -s /usr/share/intltool/Makefile.in.in $N/;done
find data -type f -name \*.py -exec sed -i 's/\r//' {} \;

%patch0
%patch1
%patch2

%build
#autoreconf
%configure --disable-update-databases --disable-xml-catalog-update
%make_build

%install
# No makeinstall macros here, because of hardcoded DESTDIR-only
make install DESTDIR=%buildroot

# Unpackaged files
rm %buildroot%_libdir/%name/*.la

%find_lang %name
for c in `echo src/plugin_*`; do
  %find_lang %{name}_`basename $c`
done
cat %{name}_plugin_*.lang >> %name.lang

%files
%_bindir/*
%_libdir/%name

%files common -f %name.lang
%exclude %_defaultdocdir/%name
%doc data/bflang/sample.bflang2 AUTHORS COPYING ChangeLog README TODO
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/pixmaps/*
%_datadir/applications/*
%_datadir/appdata/%name.appdata.xml
%_datadir/mime/packages/*
%_iconsdir/hicolor/*/*/*.??g
%_man1dir/*
%dir %_datadir/xml/%name
%_datadir/xml/%name/*

%changelog
