# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Ick!  This is only a temporary hack until I have more time
# to rebase the affected patches (#4, and possibly more)

%global wtf_ver 20170512

Summary: Collection of text-based games
Name: bsd-games
Version: 2.17
Release: alt2_58
License: BSD and BSD with advertising
Group: Games/Other
URL: ftp://metalab.unc.edu/pub/Linux/games/
Source0: ftp://metalab.unc.edu/pub/Linux/games/bsd-games-%{version}.tar.gz
Source1: config.params
# Updated acronym databases and all bsd-wtf
Source2: https://downloads.sourceforge.net/bsdwtf/wtf-%{wtf_ver}.tar.gz
# A collection of patches from Debian.
Patch0: bsd-games-2.17-debian.patch
# Patches from Fedora Core 1
Patch1: bsd-games-2.17-ospeed.patch
Patch2: bsd-games-2.17-getline.patch
Patch3: bsd-games-2.17-utmpstruct.patch
# Additional new patches
Patch4: bsd-games-2.17-setresgid.patch
Patch5: bsd-games-2.17-tetrisgid.patch
Patch6: bsd-games-2.17-hackgid.patch
Patch7: bsd-games-2.17-phantasiagid.patch
# Add patches for man page renames
Patch8: bsd-games-2.17-monop-rename.patch
Patch9: bsd-games-2.17-banner-rename.patch
Patch10: bsd-games-2.17-stdio-c++.patch
Patch11: bsd-games-2.17-nolibtermcap.patch
Patch12: bsd-games-2.17-tetris-rename.patch
Patch13: bsd-games-2.17-gcc43.patch
Patch14: bsd-games-2.17-bogglewords.patch
Patch16: bsd-games-2.17-backgammonsize.patch
Patch17: bsd-games-2.17-adventurecrc.patch
Patch18: bsd-games-2.17-wtfrpm.patch
Patch19: bsd-games-2.17-adventureinit.patch
Patch20: bsd-games-2.17-backgammonrecursion.patch
Patch21: bsd-games-2.17-huntversion.patch
Patch22: bsd-games-2.17-getrandom.patch
Patch23: bsd-games-2.17-printf.patch
BuildRequires: gcc gcc-c++ libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel words flex flex bison
Requires(pre): shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Source44: import.info

%description
Bsd-games includes adventure, arithmetic, atc, backgammon, battlestar,
bcd, caesar, canfield, cfscores, cribbage, go-fish, gomoku,
hunt, mille, mpoly, morse, number, phantasia, pig, pom, ppt, primes,
quiz, rain, random, robots, rot13, sail, snake, snscore, teachgammon,
bsd-fbg, trek, worm, worms and wump.

%prep
%setup -q -a2
install -p -m 755 %{SOURCE1} .
%patch0 -p1 -b .debian
%patch1 -p1 -b .ospeed
%patch2 -p1 -b .getline
%patch3 -p1 -b .utmpstruct
%patch4 -p1 -b .setresgid
%patch5 -p1 -b .tetrisgid
%patch6 -p1 -b .hackgid
%patch7 -p1 -b .phantasiagid
%patch8 -p1 -b .monop.rename
%patch9 -p0 -b .banner.rename
%patch10 -p0 -b .cplusplus
%patch11 -p0 -b .nolibtermcap
%patch12 -p0 -b .tetris.rename
%patch13 -p1 -b .gcc43
%patch14 -p0 -b .wordlimit
%patch16 -p0 -b .backgammonsize
%patch17 -p0 -b .adventurecrc
pushd wtf-%{wtf_ver}
%patch18 -p1 -b .wtfrpm
popd
%patch19 -p0 -b .adventureinit
%patch20 -p1 -b .backgammonrecursion
%patch21 -p1 -b .huntversion
%patch22 -p1 -b .getrandom
%patch23 -p1 -b .printf

%build
# We include a templatized configuration settings file to set
# reasonable defaults, and to tell the configure script not to
# run in interactive mode.
sed -i.bak -e "s#@DESTDIR@#$RPM_BUILD_ROOT#" \
    -e "s#@bindir@#%{_bindir}#" \
    -e "s#@docdir@#%{_docdir}#" \
    -e "s#@sbindir@#%{_sbindir}#" \
    -e "s#@datadir@#%{_datadir}#" \
    -e "s#@libdir@#%{_libdir}#" \
    -e "s#@mandir@#%{_mandir}#" \
    -e "s#@var@#%{_var}#" \
    -e "s#@RPM_OPT_FLAGS@#$RPM_OPT_FLAGS#" \
    config.params 

# Don't use %%configure.  This configure script wasn't generated by
# autoconf and doesn't obey things like --prefix.
./configure
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE" %{?_smp_mflags}

# Rename one doc file to avoid naming collisions
cp hunt/README README.hunt

%install
make RPM_BUILD_ROOT="$RPM_BUILD_ROOT" install

# Change the binary name for monop to prevent a conflict with the mono-devel
# package
mv $RPM_BUILD_ROOT/%{_bindir}/monop $RPM_BUILD_ROOT/%{_bindir}/mpoly
mv $RPM_BUILD_ROOT/%{_mandir}/man6/monop.6.gz $RPM_BUILD_ROOT/%{_mandir}/man6/mpoly.6.gz

# Change the binary name for banner to prevent a conflict with a Fedora
# package with the same name
mv $RPM_BUILD_ROOT/%{_bindir}/banner $RPM_BUILD_ROOT/%{_bindir}/vert-banner
mv $RPM_BUILD_ROOT/%{_mandir}/man6/banner.6.gz $RPM_BUILD_ROOT/%{_mandir}/man6/vert-banner.6.gz

# Change the binary name for tetris to prevent a conflict with the mono-devel
# package
mv $RPM_BUILD_ROOT/%{_bindir}/tetris-bsd $RPM_BUILD_ROOT/%{_bindir}/bsd-fbg
mv $RPM_BUILD_ROOT/%{_mandir}/man6/tetris-bsd.6.gz $RPM_BUILD_ROOT/%{_mandir}/man6/bsd-fbg.6.gz

# Remove this doc file.  We're copying it to a different location for Fedora.
rm -f $RPM_BUILD_ROOT/%{_docdir}/trek.me

# Updated acronym databases
pushd wtf-%{wtf_ver}
install -p -m 0755 wtf $RPM_BUILD_ROOT%{_bindir}/
gzip wtf.6
install -p -m 0644 wtf.6.gz $RPM_BUILD_ROOT%{_mandir}/man6/
install -p -m 0644 acronyms* $RPM_BUILD_ROOT%{_datadir}/misc/
popd

%pre
for group in gamehack gamesail gamephant; do
    getent group $group >/dev/null || groupadd -r $group
done
exit 0

%files
%{_bindir}/adventure
%{_bindir}/arithmetic
%attr(2711,root,games) %{_bindir}/atc
%{_bindir}/backgammon
%{_bindir}/teachgammon
%attr(2711,root,games) %{_bindir}/battlestar
%{_bindir}/boggle
%{_bindir}/bcd
%{_bindir}/caesar
%{_bindir}/dab
%{_bindir}/rot13
%attr(2711,root,games) %{_bindir}/canfield
%{_bindir}/cfscores
%attr(2711,root,games) %{_bindir}/cribbage
%{_bindir}/go-fish
%{_bindir}/gomoku
%attr(2711,root,gamehack) %{_bindir}/hack
%{_bindir}/hangman
%{_bindir}/hunt
%{_bindir}/mille
%{_bindir}/mpoly
%{_bindir}/morse
%{_bindir}/number
%attr(2711,root,gamephant) %{_bindir}/phantasia
%{_bindir}/pig
%{_bindir}/pom
%{_bindir}/ppt
%{_bindir}/primes
%{_bindir}/quiz
%{_bindir}/rain
%{_bindir}/random
%attr(2711,root,games) %{_bindir}/robots
%attr(2711,root,gamesail) %{_bindir}/sail
%attr(2711,root,games) %{_bindir}/snake
%{_bindir}/snscore
%attr(2711,root,games) %{_bindir}/bsd-fbg
%{_bindir}/trek
%{_bindir}/vert-banner
%{_bindir}/worm
%{_bindir}/worms
%{_bindir}/wtf
%{_bindir}/wump
%{_datadir}/%{name}
%{_datadir}/misc/acronyms
%{_datadir}/misc/acronyms-o.real
%{_datadir}/misc/acronyms.comp
%{_datadir}/misc/acronyms-o.fake
%{_mandir}/man6/*
%{_sbindir}/huntd
%config(noreplace) %attr(664,root,games) %{_var}/games/atc_score
%config(noreplace) %attr(664,root,games) %{_var}/games/battlestar.log
%config(noreplace) %attr(664,root,games) %{_var}/games/cfscores
%config(noreplace) %attr(664,root,games) %{_var}/games/criblog
%dir %attr(0775,root,gamehack) %{_var}/games/hack
%config(noreplace) %attr(664,root,gamehack) %{_var}/games/hack/*
%dir %attr(775,root,gamephant) %{_var}/games/phantasia
%config(noreplace) %attr(664,root,gamephant) %{_var}/games/phantasia/*
%dir %attr(775,root,gamesail) %{_var}/games/sail
%config(noreplace) %attr(664,root,games) %{_var}/games/robots_roll
%config(noreplace) %attr(664,root,gamesail) %{_var}/games/saillog
%config(noreplace) %attr(664,root,games) %{_var}/games/snake.log
%config(noreplace) %attr(664,root,games) %{_var}/games/snakerawscores
%config(noreplace) %attr(664,root,games) %{_var}/games/bsd-fbg.scores
%doc AUTHORS COPYING ChangeLog ChangeLog.0 THANKS YEAR2000 README.hunt trek/USD.doc/trek.me

%changelog
