%def_enable snapshot

%define _libexecdir %prefix/libexec
%define ver_major 0.4
%define api_ver 1.0
%def_enable gtk2_module
%def_enable gtk3_module

Name: caribou
Version: %ver_major.22
Release: alt3

Summary: A simplified in-place on-screen keyboard
Group: Graphical desktop/GNOME
License: LGPLv2+
Url: https://live.gnome.org/Caribou

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif
Patch:  %name-0.4.22-change_autostart_cinnamon.patch
Patch1: %name-0.4.20-fix-python-exec.patch
Patch2: %name-0.4.22-alt-russian_layouts.patch
Patch4: %name-0.4.2-use-reserved-bar-keycode.patch
Patch5: %name-0.4.2-fix-keys.patch
Patch6: %name-0.4.22-alt-fix-comparision.patch
# https://gitlab.gnome.org/GNOME/caribou/-/merge_requests/3
# https://github.com/linuxmint/cinnamon-screensaver/issues/354
Patch7: %name-0.4.22-alt-remove-xkbkeytypesmask.patch
# https://gitlab.gnome.org/GNOME/caribou/-/merge_requests/4
Patch8: %name-0.4.22-vala-cleanups.patch

Provides: on-screen-keyboard
Requires: lib%name = %version-%release
Requires: lib%name-gir = %version-%release

%define gee_ver 0.8

BuildRequires(pre): rpm-build-python3 rpm-build-gir
%{?_enable_gtk2_module:BuildRequires: libgtk+2-devel}
%{?_enable_gtk3_module:BuildRequires: libgtk+3-devel libgtk+3-gir-devel}
BuildPreReq: libgee-devel >= %gee_ver
BuildRequires: libat-spi2-core-devel libclutter-devel libxklavier-devel libXtst-devel
BuildRequires: gobject-introspection-devel python3-module-pygobject3-devel libxml2-devel
BuildRequires: intltool xsltproc gnome-doc-utils vala-tools >= 0.13

%description
Caribou is a text entry application that currently manifests itself as
a simplified in-place on-screen keyboard.

%package -n lib%name
Summary: Caribou library
Group: System/Libraries

%description -n lib%name
Caribou is a text entry application that currently manifests itself as
a simplified in-place on-screen keyboard.

This package contains Caribou library.

%package -n lib%name-devel
Summary: Development files for Caribou
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The lib%name-devel package contains libraries and headers files for
developing applications that use Caribou.

%package -n lib%name-gir
Summary: GObject introspection data for the Caribou
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Caribou library.

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Caribou
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Caribou library.

%prep
%setup
%patch -p1 -b .cinnamon
%patch1 -p1 -b .python_exec
%patch2 -p1 -b .rus
%patch4 -p2 -b .res_keycode
#%%patch5 -p2
%patch6 -p2 -b .bool_comparision
%patch7 -p1 -b .remove-xkbkeytypesmask
%patch8 -p1 -b .vala-cleanups

%build
%autoreconf
%configure --disable-static \
	%{?_disable_gtk2_module:--disable-gtk2-module} \
	%{?_disable_gtk3_module:--disable-gtk3-module} \
	PYTHON=%__python3

# Clean generated C files:
%make clean

%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/%name-preferences
%_libexecdir/%name
%_datadir/%name
%_datadir/antler/
%_datadir/dbus-1/services/org.gnome.Caribou.Antler.service
%_datadir/dbus-1/services/org.gnome.Caribou.Daemon.service
%_libexecdir/antler-keyboard
%_sysconfdir/xdg/autostart/%name-autostart.desktop
%_datadir/glib-2.0/schemas/org.gnome.antler.gschema.xml
%_datadir/glib-2.0/schemas/org.gnome.caribou.gschema.xml
%_libdir/gnome-settings-daemon-3.0/gtk-modules/%name-gtk-module.desktop
%{?_enable_gtk2_module:%_libdir/gtk-2.0/modules/lib%name-gtk-module.so}
%{?_enable_gtk3_module:%_libdir/gtk-3.0/modules/lib%name-gtk-module.so}
%python3_sitelibdir_noarch/%name/
%doc NEWS README

%exclude %_libdir/gtk-*/modules/lib%name-gtk-module.la

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/lib%name/
%_libdir/lib%name.so
%_pkgconfigdir/%name-%api_ver.pc
%_vapidir/%name-%api_ver.deps
%_vapidir/%name-%api_ver.vapi

%files -n lib%name-gir
%_typelibdir/Caribou-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Caribou-%api_ver.gir

%changelog
