%define pppconfdir %_sysconfdir/ppp
%define docdir %_datadir/chestnut-dialer/chestnut_dialer/doc
%define consolehelper %_bindir/consolehelper
%define pamdir %_sysconfdir/pam.d
%define consoleappsdir %_sysconfdir/security/console.apps

%def_disable qt
%def_enable gtk2
%def_with consolehelper

Name: chestnut-dialer
Version: 0.3.3
Release: alt8.2

Summary: A PPP dialing program, written in Python
License: GPL
Group: Networking/Remote access

Url: http://chestnut-dialer.sourceforge.net
Source: %name-%version.tar.bz2
Patch0: chestnut-dialer-0.3.2-alt-ttynames.patch
Patch1: chestnut-dialer-0.3.2-alt-quoting.patch
Patch2: chestnut-dialer-0.3.2-alt-ru.po.patch
Patch3: chestnut-dialer-0.3.2-cvs-pagetitles.patch
Patch4: chestnut-dialer-0.3.2-alt-230400.patch
Patch5: chestnut-dialer-0.3.3-alt-categories.patch
Patch6: chestnut-dialer-0.3.3-alt-mtu_mru.patch
Patch7: chestnut-dialer-0.3.3-alt-no_resolvconf.patch
Packager: Michael Shigorin <mike@altlinux.org>

Requires: ppp
Requires: python >= 2.2
Requires: python-modules-libxml2
%{?_with_consolehelper:Requires: %consolehelper}

%py_provides chestnut_dialer
# Find chestnut_dialer and other provides
%add_python_lib_path %_datadir/chestnut-dialer/

BuildArch: noarch

BuildRequires: ppp
BuildRequires: python >= 2.2
BuildRequires: python-modules-libxml2
BuildRequires: texinfo
%{?_enable_gtk2:BuildRequires: python-module-pygtk-libglade}
%{?_enable_qt:BuildRequires: python-module-qt}
%{?_with_consolehelper:BuildRequires: %consolehelper}

Summary(ru_RU.KOI8-R):     PPP,   Python.
Summary(uk_UA.KOI8-U):     PPP,   Python.

# Added by buildreq2 on Fri Nov 10 2006 (-bi)
BuildRequires: net-tools python-modules-libxml2

%description
Chestnut Dialer is PPP dialing program, written in Python.
Current version %version can work with GTK2, QT, and without GUI
(command line interface). Chestnut Dialer does not require root
permissions, but requires read and/or write access to some system
files (modem device etc.). Chestnut Dialer uses standard pppd
daemon to set up network interface.

%description -l ru_RU.KOI8-R
Chestnut Dialer -      PPP,
  Python.   (%version)  
 GTK2, QT,     (  ).
Chestnut Dialer    ,  
   /       (
 ). Chestnut Dialer    pppd
   .

%description -l uk_UA.KOI8-U
Chestnut Dialer -      PPP,
  Python. Ҧ Ӧ (%version)  
 GTK2, QT,   Ʀ  (  ).
Chestnut Dialer դ  צ ,  դ
   /      ̦ (
). Chestnut Dialer դ   pppd
 '  .

%if_enabled gtk2
%package gtk2
Summary: GTK2 user interface for Chestnut Dialer
Summary(ru_RU.KOI8-R):   GTK2  Chestnut Dialer.
Summary(uk_UA.KOI8-U):   GTK2  Chestnut Dialer.
Group: Networking/Remote access
Requires: %name = %version
Requires: python-module-pygtk
Requires: python-module-pygtk-libglade

%description gtk2
This is the GTK2 user interface for Chestnut Dialer.

%description -l ru_RU.KOI8-R gtk2
  GTK2  Chestnut Dialer.

%description -l uk_UA.KOI8-U gtk2
  GTK2  Chestnut Dialer.
%endif

%if_enabled qt
%package qt
Summary: QT user interface for Chestnut Dialer
Summary(ru_RU.KOI8-R):   QT  Chestnut Dialer.
Summary(uk_UA.KOI8-U ):   QT  Chestnut Dialer.
Group: Networking/Remote access
Requires: %name = %version
Requires: python-module-qt

%description qt
This is the QT user interface for Chestnut Dialer.

%description -l ru_RU.KOI8-R qt
  QT  Chestnut Dialer.

%description -l uk_UA.KOI8-U qt
  QT  Chestnut Dialer.
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1
#patch2 -p1
#patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%build
%configure \
	%{subst_enable gtk2} \
	%{subst_enable qt} \
	--with-pppconfdir=%pppconfdir \
	--with-docdir=%docdir \
	%{?_with_consolehelper} \
	--with-pamdir=%pamdir \
	--with-consoleappsdir=%consoleappsdir
make

%install
make DESTDIR=%buildroot install
install -m 0755 -d %buildroot%_datadir/applications
install -m 0644 chestnut-dialer-gtk2.desktop %buildroot%_datadir/applications/
install -m 0644 chestnut-dialer-qt.desktop %buildroot%_datadir/applications/

%files
%doc AUTHORS COPYING ChangeLog NEWS* README* FAQ*
%doc %docdir
%_infodir/%{name}*.info*
%_man1dir/chestnut-dialer*
%pppconfdir/peers/*
%_bindir/chestnut-dialer
%if_with consolehelper
%_sbindir/chestnut-dialer
%pamdir/chestnut-dialer
%consoleappsdir/chestnut-dialer
%endif
%_datadir/chestnut-dialer/chestnut_dialer/dobj
%_datadir/chestnut-dialer/chestnut_dialer/dockicons
%_datadir/chestnut-dialer/chestnut_dialer/importers
%_datadir/chestnut-dialer/chestnut_dialer/none_ui
%_datadir/chestnut-dialer/chestnut_dialer/*.py*
%_datadir/chestnut-dialer/chestnut_dialer/*.x*
%_datadir/locale/*/LC_MESSAGES/chestnut-dialer.mo
%_pixmapsdir/chestnut-dialer.png

%if_enabled gtk2
%files gtk2
%_datadir/chestnut-dialer/chestnut_dialer/gtk2_ui
%_datadir/applications/chestnut-dialer-gtk2.desktop
%endif

%if_enabled qt
%files qt
%_datadir/chestnut-dialer/chestnut_dialer/qt_ui
%_datadir/applications/chestnut-dialer-qt.desktop
%endif

# TODO
# - move from /usr/share/chestnut-dialer
#          to /usr/lib/chestnut-dialer
#   (see /usr/share/doc/rpm-build-python-0.29/policy/draft/4-Python_TOOLS.txt)
# - check ru.po

%changelog
