%define ver_major 4.2
%define _libexecdir %_prefix/libexec
%define _name cinnamon

%def_disable wmsession

Name: %{_name}-session
Version: %ver_major.1
Release: alt2

License: GPLv2+
Summary: The cinnamon session programs for the Cinnamon GUI desktop environment
Group: Graphical desktop/GNOME
URL: https://github.com/linuxmint/cinnamon-session
Packager: Vladimir Didenko <cow@altlinux.org>

Source: %name-%version.tar
Source1: %{_name}.session
Source2: %{_name}2d.session
Source3: start%{_name}-common
Source4: start%{_name}
Source5: start%{_name}2d
Source6: 02Cinnamon
Source7: 02Cinnamon2D
Source8: %{_name}.desktop
Source9: %{_name}2d.desktop
Patch: %name-%version-%release.patch

# From configure.in
%define glib_ver 2.33.4
%define gtk_ver 3.0.0
%define polkit_ver 0.91
%define upower_ver 0.9

%{?_enable_wmsession:Requires(pre): xinitrc}
Requires: dconf libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-cinnamon
Requires: gstreamer1.0 dbus-tools-gui
Requires: gnome-filesystem
Requires: cinnamon-settings-daemon
Requires: nemo
Requires: upower polkit-gnome gcr
Requires: %name-translations
Requires: cinnamon-screensaver

# From configure.in
BuildRequires(pre): meson
BuildPreReq: intltool >= 0.35.0
BuildPreReq: libgio-devel glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libupower-devel >= %upower_ver
BuildRequires: libpangox-compat-devel librsvg-devel libjson-glib-devel
BuildRequires: libX11-devel libXau-devel libXrandr-devel libXrender-devel libXt-devel
BuildRequires: libSM-devel libXext-devel libXtst-devel libXi-devel libXcomposite-devel libGL-devel
BuildRequires: xorg-xtrans-devel
BuildRequires: libcanberra-devel
BuildRequires: libcinnamon-desktop-devel
BuildRequires: xmlto
BuildRequires: libsystemd-devel libpolkit-devel
BuildRequires: libxapps-devel

%description
Cinnamon is a Linux desktop which provides advanced innovative features
and a traditional user experience. The desktop layout is similar to Gnome 2.
The underlying technology is forked from Gnome Shell. The emphasis is put on
making users feel at home and providing them with an easy to use and comfortable
desktop experience.

This package provides the Cinnamon session manager.

%prep
%setup -q
%patch0 -p1

%build
%meson -Dwith-gconf=false --libexecdir=%_libexecdir
%meson_build

%install
%meson_install

install -pD -m655 %SOURCE1 %buildroot%_datadir/%name/sessions/%{_name}.session
install -pD -m655 %SOURCE2 %buildroot%_datadir/%name/sessions/%{_name}2d.session
install -pD -m755 %SOURCE3 %buildroot%_datadir/%name/start%{_name}-common
install -pD -m755 %SOURCE4 %buildroot%_bindir/start%{_name}
install -pD -m755 %SOURCE5 %buildroot%_bindir/start%{_name}2d

%if_enabled wmsession
mkdir -p %buildroot%_x11sysconfdir/wmsession.d
install -pD -m655 %SOURCE6 %buildroot%_x11sysconfdir/wmsession.d
install -pD -m655 %SOURCE7 %buildroot%_x11sysconfdir/wmsession.d
%endif

mkdir -p %buildroot%_datadir/xsessions
install -pD -m655 %SOURCE8 %buildroot%_datadir/xsessions
install -pD -m655 %SOURCE9 %buildroot%_datadir/xsessions

rm -f %buildroot%_docdir/%name/dbus/cinnamon-session.html

%find_lang --with-gnome --output=%name.lang %name-3.0

%files -f %name.lang
%_bindir/*
%_libexecdir/cinnamon-session-check-accelerated
%_libexecdir/cinnamon-session-check-accelerated-helper
%dir %_datadir/%name
%_datadir/%name/*.glade
%_datadir/%name/hardware-compatibility
%_datadir/%name/start%{_name}-common
%dir %_datadir/%name/sessions
%_datadir/%name/sessions/%{_name}.session
%_datadir/%name/sessions/%{_name}2d.session
%_iconsdir/hicolor/*/apps/cinnamon-session-properties.*
%config %_datadir/glib-2.0/schemas/org.cinnamon.SessionManager.gschema.xml
%_mandir/man?/*
%{?_enable_wmsession:%_x11sysconfdir/wmsession.d/*}
%_datadir/xsessions/*.desktop
%doc AUTHORS NEWS README

%changelog
