Name: cups
Version: 2.3.3
Release: alt7.op2

Summary: Common Unix Printing System - server package
License: Apache-2.0
Group: System/Servers

Url: https://openprinting.github.io/cups/

# https://github.com/OpenPrinting/cups/
Source: %name-%version.tar

# READMEs
Source10: README.alt
Source11: README.patches

# MISC
Source20: cups.control
Source21: cups.startup

# support
Source95: %name.unused
Source96: repatch_spec.sh
Source97: alt_ru.po
Source98: pofix.py

## FC patches
Patch1: FC-system-auth.patch
Patch2: FC-multilib.patch
Patch3: FC-banners.patch
Patch4: FC-no-export-ssllibs.patch
Patch5: FC-direct-usb.patch
Patch6: FC-driverd-timeout.patch
Patch7: FC-logrotate.patch
Patch8: FC-usb-paperout.patch
Patch9: FC-uri-compat.patch
Patch13: FC-freebind.patch
Patch14: FC-ipp-multifile.patch
Patch15: FC-web-devices-timeout.patch
Patch18: FC-failover-backend.patch
Patch19: FC-lspp.patch
Patch20: FC-filter-debug.patch
Patch21: FC-dymo-deviceid.patch

## Ubuntu patches
Patch101: Ubuntu-0001-Fix-hyphen-used-as-minus-sign-manpage-errors.patch
Patch103: Ubuntu-0003-Fix-jobs-with-multiple-files-or-multiple-formats.patch
Patch106: Ubuntu-0006-Tests-ignore-usb-dnssd-backend-unexpected-exits.patch
Patch107: Ubuntu-0007-Tests-ignore-loadFile-failures.patch
Patch108: Ubuntu-0008-Tests-ignore-errors-triggered-on-ipv6-deprived-hosts.patch
Patch109: Ubuntu-0009-Tests-ignore-the-failure-to-write-uncompressed-data.patch
Patch110: Ubuntu-0010-Tests-ignore-job-held-message.patch
Patch113: Ubuntu-0013-Tests-Force-LC_-environment-variables-when-testing-n.patch
Patch114: Ubuntu-0014-Tests-Use-127.0.0.1-instead-of-localhost-to-help-pbu.patch
Patch115: Ubuntu-0015-Tests-Force-LC_ALL-C-environment-variable-when-grepp.patch
Patch117: Ubuntu-0017-Move-cupsd.conf.default-from-SERVERROOT-to-DATADIR.patch
Patch118: Ubuntu-0018-Patch-to-support-Apple-AirPrint-printing-from-iPhone.patch
Patch119: Ubuntu-0019-Let-snmp-backend-also-use-manufacturer-specific-MIBs.patch
Patch121: Ubuntu-0021-Do-not-write-VCS-tags-into-installed-conffiles.patch
Patch122: Ubuntu-0022-Rename-the-systemd-service-file-from-org.cups.cups.-.patch
Patch124: Ubuntu-0024-CUPS-removes-the-recommended-comments-of-the-NickNam.patch
Patch125: Ubuntu-0025-Make-log-files-readable-to-group-adm-if-present.patch
Patch126: Ubuntu-0026-Deactivate-CUPS-own-log-rotating-as-the-system-alrea.patch
Patch127: Ubuntu-0027-Do-not-mess-with-the-permissions-of-cupsd.conf.patch
Patch128: Ubuntu-0028-Show-compile-command-lines.patch
Patch129: Ubuntu-0029-Set-the-default-for-SyncOnClose-to-Yes.patch
Patch130: Ubuntu-0030-Set-default-job-error-policy-to-retry-job.patch
Patch133: Ubuntu-0033-Build-mantohtml-with-the-build-architecture-compiler.patch
Patch134: Ubuntu-0034-po4a-infrastructure-and-translations-for-manpages.patch
Patch136: Ubuntu-0006-Fix-leakage-of-ppd.patch
Patch137: Ubuntu-0025-Add-Requires-cups.socket-to-cups.service-to-make-sur.patch

## ALT patches
Patch500: ALT-1.6.1-hardening.patch
Patch501: ALT-build_po.patch
Patch502: ALT-remove_BSD.patch
Patch503: ALT-enable-631.patch
Patch504: ALT-1.6.2-lpd-utf8.patch
Patch505: ALT-1.4.6-config-libs.patch
Patch506: ALT-1.6.2-lspp-SE.patch
Patch507: ALT-1.7.0-docroot-i18n.patch
Patch508: ALT-644.patch
Patch509: ALT-1.7.2-local_ipv6.patch
Patch510: ALT-config-nolibs.patch
Patch511: ALT-pwg-raster-attributes.patch
Patch512: ALT-2.1.0-lpd-sanitizer.patch
# ALT SE related patches
Patch552: ALT-ipp-alt-extension-copy-document.patch
Patch553: ALT-lspp-context+no-filename.patch
Patch555: ALT-2.1.0-check-PPD-SE.patch
Patch556: ALT-lspp-context-via-tcp.patch
Patch557: ALT-lspp-set-context-via-ipp.patch
Patch558: ALT-lspp-in-alt-job-ft.patch
Patch559: ALT-mime-pjl-pdf.patch
Patch560: ALT-SE-ippcalls.patch

# Upstream patches
Patch900: upstream-0001-backend-usb-libusb.c-Use-60s-timeout-for-reading-.patch
Patch901: upstream-0002-backend-usb-libusb.c-Revert-enforcing-read-limits.patch

## Provides
Provides: %name-ppd = %version %name-common = %version
Provides: cups-libs = %version

## External dependencies
Requires: printer-testpages bc cups-filters

# Automatically added by buildreq on Tue Dec 24 2013
# optimized out: libcom_err-devel libkrb5-devel libstdc++-devel libsystemd-daemon pkg-config
BuildRequires: gcc-c++ libacl-devel libaudit-devel libavahi-devel libdbus-devel libpam-devel libpaper-devel libselinux-devel libssl-devel libsystemd-daemon-devel systemd-devel libusb-devel xdg-utils zlib-devel

BuildRequires: dbus python3 python3-module-polib
BuildRequires: libgnutls-devel

%description
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. It has been developed by Easy Software Products
to promote a standard printing solution for all UNIX vendors and users.
CUPS provides the System V and Berkeley command-line interfaces.

This is the main package needed for CUPS servers (machines where a
printer is connected to or which host a queue for a network
printer). It can also be used on CUPS clients so that they simply pick
up broadcasted printer information from other CUPS servers and do not
need to be assigned to a specific CUPS server by an
/etc/cups/client.conf file.

%package ipptool
Summary: Common Unix Printing System - tool for performing IPP requests
Group: System/Servers

%description ipptool
Sends IPP requests to the specified URI and tests and/or displays the results.

%package xinetd
Summary: Common Unix Printing System - xinetd profile
Group: System/Servers
BuildArch: noarch

%description xinetd
Common Unix Printing System - xinetd profile

%package -n lib%name
Summary: Common Unix Printing System - CUPS library
Group: System/Servers

%description -n lib%name
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. This package contains the CUPS API library
which contains common functions used by both the CUPS daemon and all
CUPS frontends (lpr-cups, xpp, qtcups, kups, ...).

%package -n lib%name-devel
Summary: Common Unix Printing System - Development environment "libcups"
Group: Development/C
Requires: lib%name = %version-%release
Provides: %name-devel = %version %name-ddk = %version

%description -n lib%name-devel
The Common Unix Printing System provides a portable printing layer for
UNIX(TM) operating systems. This is the development package for
creating additional printer drivers, printing software, and other CUPS
services using the main CUPS library "libcups".

%prep
%setup -n %name-%version

## FC apply patches
%patch1 -p1 -b .system-auth
#patch2 -p1 -b .multilib
%patch3 -p1 -b .banners
%patch4 -p1 -b .no-export-ssllibs
%patch5 -p1 -b .direct-usb
%patch6 -p1 -b .driverd-timeout
%patch7 -p1 -b .logrotate
%patch8 -p1 -b .usb-paperout
#patch9 -p1 -b .uri-compat
%patch13 -p1 -b .freebind
%patch14 -p1 -b .ipp-multifile
%patch15 -p1 -b .web-devices-timeout
%patch18 -p1 -b .failover
%patch19 -p1 -b .lspp
%patch20 -p1 -b .filter-debug
%patch21 -p1 -b .dymo-deviceid

## Ubuntu apply patches
%patch101 -p1
#patch103 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1
%patch117 -p1
%patch118 -p1
#patch119 -p1
%patch121 -p1
#patch122 -p1
%patch124 -p1
##patch125 -p1
%patch126 -p1
%patch127 -p1
%patch128 -p1
#patch129 -p1
%patch130 -p1
%patch133 -p1
#patch134 -p1
##patch136 -p1
##patch137 -p1

## ALT apply patches
##patch500 -p1
%patch501 -p1
%patch502 -p1
%patch503 -p2
%patch504 -p1
#patch505 -p1
%patch506 -p1
%patch507 -p1
%patch508 -p1
%patch509 -p1
#patch510 -p1
%patch511 -p1
%patch512 -p2

# ALT SE related patches
%patch552 -p1
%patch553 -p1
%patch555
%patch556 -p1
%patch557 -p1
%patch558 -p1
%patch559 -p1
%patch560 -p2

# Upstream patches
# https://github.com/OpenPrinting/cups/pull/174
%patch900 -p1
%patch901 -p1

cp %SOURCE98 %SOURCE97 %SOURCE10 %SOURCE11 .
cp %SOURCE21 scheduler/cups.sh.in

# TODO help translation injecting

%build
aclocal -I config-scripts
autoconf -I config-scripts

export LIBS="-laudit -lselinux"
%configure \
   --with-system-groups='sys wheel root' \
   --with-icondir=%_iconsdir \
   --with-menudir=%_desktopdir \
   --with-xinetd=%_sysconfdir/xinetd.d \
   --enable-relro \
   --enable-dbus \
   --enable-libusb \
   --with-cups-user=lp \
   --with-cups-group=lp \
   --with-log-file-perm=0600 \
   --with-docdir=%_docdir/%name \
   --with-rcdir=%_initdir/.. \
   --localstatedir=%_var \
   --enable-avahi \
   --with-local_protocols='dnssd' \
   --enable-lspp \
   --enable-libpaper \
   --enable-debug \
   --enable-gnutls \
   --enable-sync-on-close \
   --with-error-policy=retry-job \
   %nil

%make_build

(
cd locale
make pot
mv cups_ru.po cups_old_ru.po
msgmerge cups_old_ru.po cups.pot -C ../alt_ru.po -o cups_ru.po
python3 ../pofix.py cups_ru.po
)

%install
make BUILDROOT=%buildroot install

# fixup funny org.cups.*.* names
( cd %buildroot%_unitdir;
for f in *; do
  case "$f" in
    org.cups.cupsd.*) ln -s "$f" cups."${f##*.}";;
    org.cups.*) ln -s "$f" "${f/org.cups./}";;
  esac;
done;
echo "###"; ls
)

### install non-upstream files
install -D scheduler/cups-lpd.xinetd %buildroot%_sysconfdir/xinetd.d/cups-lpd
install -Dpm 755 %SOURCE20 %buildroot%_controldir/%name

alternate() { # priority files \
p="$1"; shift; \
for f; do \
  case "$f" in \
  	*/sbin/*) man=8;; \
  	*/bin/*) man=1;; \
	*/etc/*|*/share/*) man=5;; \
	*) man=6;; \
  esac; \
  mp="%_mandir/man$man"; \
  n="$(basename "$f")"; fa="$f-%name"; m="$mp/$n.$man"; ma="$mp/$n-%name.$man"; \
  /bin/echo -e "$f $fa $p\n$m.gz $ma.gz $fa"; \
  mv "%buildroot$f" "%buildroot$fa"; mv "%buildroot$m" "%buildroot$ma"; \
done }

alternate 10 \
	/usr/bin/lpr \
	/usr/bin/lpq \
	/usr/bin/lprm \
	/usr/bin/lp \
	/usr/bin/cancel \
	/usr/bin/lpstat \
	/usr/sbin/lpc > %name.alternative

install -D %name.alternative %buildroot%_altdir/%name
# #36909 close
chmod 755 %buildroot/usr/lib/cups/backend/ipp

%post
%post_service cups

%preun
%preun_service cups

%triggerun -- %name < 2.3.3-alt2.op2
if [ $2 -gt 0 ]; then
# This is cups upgrade.
	SYSTEMCTL=/bin/systemctl
	if /sbin/sd_booted && "$SYSTEMCTL" --version >/dev/null 2>&1 ; then
# collect service states
		enable_lpd_socket=0
		enable_cups_path=0
		enable_cups_service=0
		enable_cups_socket=0

		if "$SYSTEMCTL" is-enabled org.cups.cups-lpd.socket >/dev/null 2>&1 ; then
			enable_lpd_socket=1
		fi

		if "$SYSTEMCTL" is-enabled org.cups.cupsd.path >/dev/null 2>&1 ; then
			enable_cups_path=1
		fi

		if "$SYSTEMCTL" is-enabled org.cups.cupsd.service >/dev/null 2>&1 ; then
			enable_cups_service=1
		fi

		if "$SYSTEMCTL" is-enabled org.cups.cupsd.socket >/dev/null 2>&1 ; then
			enable_cups_socket=1
		fi

# disable services with old names
		"$SYSTEMCTL" disable --now org.cups.cups-lpd.socket ||:
		"$SYSTEMCTL" disable --now org.cups.cupsd.path ||:
		"$SYSTEMCTL" disable --now org.cups.cupsd.service ||:
		"$SYSTEMCTL" disable --now org.cups.cupsd.socket ||:

# re-enable services with new names
		if [ $enable_lpd_socket -eq 1 ] ; then
			"$SYSTEMCTL" enable --now cups-lpd.socket
		fi

		if [ $enable_cups_path -eq 1 ] ; then
			"$SYSTEMCTL" enable --now cups.path
		fi

		if [ $enable_cups_service -eq 1 ] ; then
			"$SYSTEMCTL" enable --now cups.service
		fi

		if [ $enable_cups_socket -eq 1 ] ; then
			"$SYSTEMCTL" enable --now cups.socket
		fi
	fi
fi

%files
%doc README*
%_docdir/%name
%config(noreplace) %_sysconfdir/%name
%config(noreplace) %attr(0640,root,lp) %_sysconfdir/%name/snmp.conf
%config(noreplace) %_sysconfdir/pam.d/%name
%config(noreplace) %_sysconfdir/dbus-1/system.d/*
%_controldir/%name
%_unitdir/*
%_initdir/%name
%prefix/lib/%name
%_man1dir/*
%_man5dir/*
%_man8dir/*
%_man7dir/*

%_datadir/%name
%_datadir/locale/*/*.po
%_sbindir/*
%_bindir/*
%_altdir/%name

%_iconsdir/hicolor/*/apps/*.png
%_desktopdir/%name.desktop

%exclude %prefix/*/*/*/ipptool*
%exclude %prefix/*/*/ipptool*
%exclude %prefix/*/ipptool*
%exclude %_bindir/%name-config
%exclude %_bindir/ppd*
%exclude %_mandir/*/ppd*
%exclude %_datadir/%name/examples
%exclude %_sysconfdir/rc.d/rc*.d

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_bindir/%name-config
%_bindir/ppd*
%_includedir/%name
%_datadir/%name/examples
%_libdir/*.so
%_man1dir/ppd*
%_man5dir/ppd*

%files ipptool
%_bindir/ipptool
%_datadir/cups/ipptool
%_man1dir/ipptool.*

%files xinetd
%config(noreplace) %_sysconfdir/xinetd.d/%name-lpd

%changelog
