%def_without static

Name: ddrescue
Version: 1.24
Release: alt1

Summary: Data copying in presence of I/O errors
License: GPLv3+
Group: Archiving/Backup

URL: http://www.gnu.org/software/ddrescue/ddrescue.html
Source0: http://ftp.gnu.org/gnu/ddrescue/%{name}-%{version}.tar.lz
Source1: ddrescue.watch

# Automatically added by buildreq on Wed Dec 31 2008
BuildRequires: gcc-c++ lzip
%{?_with_static: BuildRequires: libstdc++-devel-static}
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
ddrescue copies data from one file or block device (hard disk, cdrom...)
to another, trying hard to rescue data in case of read errors.

ddrescue does not truncate the output file if not asked to. So everytime
you run it on the same output file it tries to fill in the gaps.

If you have two or more copies of a damaged file, cdrom, etc, and run
ddrescue on all of them, one at a time, with the same output file, you
will probably obtain a complete and error-free file.

%package static
Summary: Statically built ddrescue (data recovery tool)
Group: Archiving/Backup

%description static
ddrescue copies data from one file or block device (hard disk, cdrom...)
to another, trying hard to rescue data in case of read errors.

This package contains statically built ddrescue utility.

%prep
%setup

%build
./configure --prefix=%_prefix --infodir=%_infodir --mandir=%_mandir
%make_build CXXFLAGS="%optflags %optflags_nocpp" all %{?_with_static:sddrescue}
make check

%install
%makeinstall_std install-man
%{?_with_static: install -pDm755 sddrescue %buildroot/bin/sddrescue}

%files
%_bindir/ddrescue
%_bindir/ddrescuelog
%_man1dir/*
%_infodir/*.info*
%doc README

%if_with static
%files static
/bin/sddrescue
%endif

%changelog
