%define ver_major 3.32
%define xdg_name org.gnome.PowerStats

Name: gnome-power-manager
Version: %ver_major.0
Release: alt1

Summary: GNOME Power management tools
License: %gpl2plus
Group: Graphical desktop/GNOME
Url: http://www.gnome.org/projects/gnome-power-manager/

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Requires: common-licenses
Requires: upower >= 0.9.7

BuildPreReq: rpm-build-gnome >= 0.5
BuildPreReq: rpm-build-licenses

BuildPreReq: meson
BuildPreReq: glib2-devel >= 2.46.0
BuildPreReq: libgtk+3-devel >= 3.3.8
BuildPreReq: libupower-devel >= 0.99.0
BuildRequires: libappstream-glib-devel
# for docbook2man
BuildPreReq: docbook-utils
BuildPreReq: gnome-common

%description
GNOME Power Manager comes in three parts:

- gnome-settings-daemon plugin: the manager daemon itself
- gnome-control-center panel:   the control panel program, for configuration
- gnome-power-statistics:       the statistics graphing program


%prep
%setup

%build
%meson \
    -Denable-tests=true
%meson_build

%check
%meson_test

%install
%meson_install

# The license
ln -sf %_licensedir/GPL-2 COPYING

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/gnome-power-statistics
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%config %_datadir/glib-2.0/schemas/org.gnome.power-manager.gschema.xml
%_man1dir/*.1.*
%_datadir/metainfo/%xdg_name.appdata.xml

%doc --no-dereference COPYING
%doc README AUTHORS


%changelog
