# build ids are not currently generated:
# https://code.google.com/p/go/issues/detail?id=5238
#
# also, debuginfo extraction currently fails with
# "Failed to write file: invalid section alignment"
%global __find_debuginfo_files %nil

# we are shipping the full contents of src in the data subpackage, which
# contains binary-like things (ELF data for tests, etc)
%global _unpackaged_files_terminate_build 1

%global go_arches %ix86 x86_64 aarch64 %arm mipsel ppc64le riscv64
%global go_root %_prefix/lib/golang

%ifarch x86_64
%global go_hostarch  amd64
%endif
%ifarch %ix86
%global go_hostarch  386
%endif
%ifarch %arm
%global go_hostarch  arm
%endif
%ifarch aarch64
%global go_hostarch  arm64
%endif
%ifarch mipsel
%global go_hostarch  mipsle
%endif
%ifarch ppc64le
%global go_hostarch  ppc64le
%endif
%ifarch riscv64
%global go_hostarch  riscv64
%endif


%def_disable check

Name:    golang
Version: 1.15.15
Release: alt1
Summary: The Go Programming Language
Group:   Development/Other
License: BSD
URL:     http://golang.org/

Source0: golang-%version.tar
Source1: golang-gdbinit
Patch2:  golang-alt-certs-path.patch
Patch100: 0001-Don-t-use-the-bundled-tzdata-at-runtime-except-for-t.patch
Patch101: 0001-avoid-requires-libselinux-utils.patch

ExclusiveArch: %go_arches

%set_verify_elf_method skip
%add_debuginfo_skiplist %go_root
%brp_strip_none %go_root/bin/*

AutoReq: nocpp

Requires: %name-src = %version-%release

BuildRequires(pre): rpm-build-golang rpm-build-python3
BuildRequires: golang
BuildRequires: libselinux-utils
BuildRequires: libpcre-devel

# for test suite
%{?_enable_check:BuildRequires: /proc}

Provides: go = %version-%release

Provides:  golang-godoc = %version-%release
Obsoletes: golang-godoc < %version-%release

# Due to vet, cover utilities.
Conflicts: golang-tools <= 0-alt1.git7e09e072
# /usr/bin/cover
Conflicts: perl-Devel-Cover

%description
Go is expressive, concise, clean, and efficient. Its concurrency mechanisms
make it easy to write programs that get the most out of multicore and
networked machines, while its novel type system enables flexible and
modular program construction.


%package gdb
Summary:   The Go Runtime support for GDB
Group:     Development/Other
BuildArch: noarch
Requires:  %name = %version-%release
Requires:  gdb
AutoReq: nopython
%add_python3_path %go_root/src/runtime
%add_python3_compile_exclude %go_root/src/runtime
%add_python3_req_skip gdb

%description gdb
The Go Runtime support for GDB.


%ifarch x86_64
%package shared
Summary: Golang shared object libraries
Group:   Development/Other

%description shared
%summary.
%endif


%package docs
Summary:   Go sources and documentation
Group:     Documentation
BuildArch: noarch
Requires:  %name = %version-%release

%description docs
Go sources and documentation.

%package misc
Summary:   Golang compiler miscellaneous sources
Group:     Development/Other
BuildArch: noarch
Requires:  %name = %version-%release
AutoReqProv: no

%description misc
%summary.

%package tests
Summary:   Golang compiler tests for stdlib
Group:     Development/Other
BuildArch: noarch
Requires:  %name = %version-%release

%description tests
%summary.

%package src
Summary:   Golang compiler source tree
Group:     Development/Other
BuildArch: noarch

%description src
%{summary}.

%prep
%setup -q

%patch2 -p1
%patch100 -p1
%patch101 -p1

%build
# go1.5 bootstrapping. The compiler is written in golang.
export GOROOT_BOOTSTRAP=%go_root

# set up final install location
export GOROOT_FINAL=%go_root

export GOHOSTOS=linux
export GOHOSTARCH=%go_hostarch

export GOOS=linux
export GOARCH=%go_hostarch

# use our gcc options for this build, but store gcc as default for compiler
export CC="gcc"
export CC_FOR_TARGET="gcc"
export CFLAGS="$RPM_OPT_FLAGS"
export LDFLAGS="$RPM_LD_FLAGS"

# build
cd src
./make.bash --no-clean
cd ..

%ifarch x86_64
export GOROOT=$PWD
export PATH="$GOROOT/bin:$PATH"

# TODO get linux/386 support for shared objects.
# golang shared objects for stdlib
go install -v -buildmode=shared std
%endif


%check
export GOROOT=$PWD
export PATH="$GOROOT/bin:$PATH"
export CGO_ENABLED=0
export CC="gcc"
export CFLAGS="$RPM_OPT_FLAGS"
export LDFLAGS="$RPM_LD_FLAGS"

cd src
./run.bash --no-rebuild -v -k


%install
# create the top level directories
mkdir -p -- \
	%buildroot/%_bindir \
	%buildroot/%go_root \
	%buildroot/%_datadir/%name

cp -afv api bin doc favicon.ico lib pkg robots.txt src misc test VERSION \
	%buildroot/%go_root/

find %buildroot/%go_root -exec touch -r $PWD/VERSION "{}" \;

# remove bootstrap files
rm -rfv -- %buildroot/%go_root/pkg/bootstrap

# remove testdata, tests, and non-go files
find \
	%buildroot/%go_root/src \
	\( \
		\( -type d -name 'testdata'   \) -o \
		\( -type f -name 'Makefile'   \) -o \
		\( -type f -name '*_test.go'  \) -o \
		\( -type f -name 'test_*'     \) -o \
		\( -type f -name '*test.bash' \) -o \
		\( -type f -name 'test.'      \) \
	\) \
		-print0 |
	xargs -0 rm -rfv --

# remove scripts for other platform.
find \
	%buildroot/%go_root/src \
		-maxdepth 1 \
	\( \
		\( -type f -name '*.rc'  \) -o \
		\( -type f -name '*.bat' \)    \
	\) \
		-print0 |
	xargs -0 rm -fv --

# remove test for other platforms scripts
rm %buildroot/%go_root/test/winbatch.go

# remove the unnecessary zoneinfo file (Go will always use the system one first)
rm -rfv -- \
	%buildroot/%go_root/lib/time

# add symlinks for binaries.
for z in %buildroot%go_root/bin/*; do
	[ -x "$z" ] || continue

	n="${z##*/}"
	path="$(relative "$z" "%buildroot/%_bindir/$n")"

	ln -sv -- "$path" %buildroot/%_bindir/$n
done

# https://golang.org/doc/go1.5#moving
# Because the go/types package has now moved into the main repository (see below),
# the vet and cover tools have also been moved. They are no longer maintained in
# the external golang.org/x/tools repository, although (deprecated) source still
# resides there for compatibility with old releases.
for z in cover vet; do
	z="%buildroot%go_root/pkg/tool/linux_%{go_hostarch}/$z"
	[ -x "$z" ] || continue

	n="${z##*/}"
	path="$(relative "$z" "%buildroot/%_bindir/$n")"

	ln -sv -- "$path" %buildroot/%_bindir/$n
done

# restore the gdb debugging script, needed at runtime by gdb
mkdir -p -- %buildroot/%_datadir/%name/gdb
sed \
    -e 's,@GOROOT@,%go_root,g' \
    %SOURCE1 > %buildroot/%_datadir/%name/gdb/golang-gdbinit

mkdir -p -- %buildroot/%_datadir/%name/src
for n in syscall regexp; do
	mkdir -- %buildroot/%_datadir/%name/src/$n

	find %buildroot/%go_root/src/$n \
		\( \
			\( -type f -name '*.sh' \) -o \
			\( -type f -name '*.pl' \)    \
		\) \
			-print0 |
		xargs -0 mv -fvt %buildroot/%_datadir/%name/src/$n --
done

# ensure these exist and are owned
mkdir -p -- \
	%buildroot/%go_path/src/github.com \
	%buildroot/%go_path/src/bitbucket.org \
	%buildroot/%go_path/src/code.google.com/p \
	%buildroot/%go_path/src/golang.org/x \
#

%files
%_bindir/*
%go_root
%go_path
%exclude %go_root/doc
%exclude %go_root/misc
%exclude %go_root/src
%exclude %go_root/test

%ifarch x86_64
%exclude %go_root/pkg/linux_%{go_hostarch}_dynlink

%files shared
%go_root/pkg/linux_%{go_hostarch}_dynlink
%endif


%files gdb
%_datadir/%name/gdb
%go_root/src/runtime/runtime-gdb.py


%files docs
%doc AUTHORS CONTRIBUTORS LICENSE PATENTS VERSION
%dir %_datadir/%name
%_datadir/%name/src
%go_root/doc

%files misc
%go_root/misc

%files tests
%go_root/test

%files src
%go_root/src
%exclude %go_root/src/runtime/runtime-gdb.py

%changelog
