Name: grep
Version: 3.3.0.16.268ca
Release: alt1

Summary: The GNU versions of grep pattern matching utilities
License: GPLv3+
Group: File tools
Url: https://www.gnu.org/software/grep/

%define srcname %name-%version-%release
# git://git.altlinux.org/people/ldv/packages/grep refs/heads/grep-current
Source0: %srcname.tar
# git://git.altlinux.org/people/ldv/packages/grep refs/heads/po-current
Source1: po-%version-%release.tar

Source3: GREP_COLORS
Source4: color_grep.sh
Source5: color_grep.csh

# due to libpcre relocation.
Requires: libpcre3 >= 0:6.4-alt2
Provides: pcre-grep, pgrep
Obsoletes: pcre-grep, pgrep

BuildRequires: makeinfo, gnulib >= 0.1.2305.95c96
# due to build from git
BuildRequires: gperf
# due to --perl-regexp
BuildRequires: libpcre-devel

%description
The GNU versions of commonly used grep utilities.  grep searches through
textual input for lines which contain a match to a specified pattern
and then prints the matching lines.  GNU's grep utilities include grep,
egrep, fgrep, and pcregrep.

%prep
%setup -n %srcname -a1

# Build scripts expect to find the grep version in this file.
echo -n %version > .tarball-version

# Generate LINGUAS file.
ls po/*.po | sed 's|.*/||; s|\.po$||' > po/LINGUAS

# git and rsync aren't needed for build.
sed -i '/^\(git\|rsync\)[[:space:]]/d' bootstrap.conf

%build
./bootstrap --skip-po --gnulib-srcdir=%_datadir/gnulib

# Unset the variable gl_printf_safe to indicate that we do not need
# a safe handling of non-IEEE-754 'long double' values.
sed -i 's/gl_printf_safe=yes/gl_printf_safe=/' m4/gnulib-comp.m4 configure

%configure \
	--bindir=/bin \
	--disable-silent-rules \
	--enable-gcc-warnings \
	#
%make_build

%install
%makeinstall_std bindir=/bin

# Use symlinks for pcregrep
ln -s grep %buildroot/bin/pcregrep
ln -s grep.1 %buildroot%_man1dir/pcregrep.1

mkdir -p %buildroot%_sysconfdir/profile.d
install -pm755 %_sourcedir/color_grep.{sh,csh} \
	%buildroot%_sysconfdir/profile.d/
install -pm644 %_sourcedir/GREP_COLORS \
	%buildroot%_sysconfdir/

%find_lang %name

%check
# pcre-jitstack needs more stack space
ulimit -s 32768
%make_build -k check

%files -f %name.lang
%config(noreplace) %_sysconfdir/GREP_COLORS
%config(noreplace) %_sysconfdir/profile.d/*
/bin/*
%_mandir/man?/*
%_infodir/*.info*
%doc AUTHORS NEWS README TODO

%changelog
