%def_with sb_kern_signature_check_relaxed
%define efi_arches %ix86 x86_64 aarch64

Name: grub
Version: 2.02
Release: alt29.qa5

Summary: GRand Unified Bootloader
License: GPL-3
Group: System/Kernel and hardware

Url: http://www.gnu.org/software/grub

ExclusiveArch: %ix86 x86_64 aarch64 ppc64le

Source0: %name-%version.tar
Source1: grub2-sysconfig

Source3: 39_memtest
Source4: grub.filetrigger

Source5: grub-extras-%version.tar

Source6: grub-autoupdate

Source8: update-grub
Source9: update-grub.8

Source10: grub-efi-autoupdate
Source11: embedded_grub.cfg

Source12: grub-entries
Source13: grub-entries.8

Source14: grub-efi.filetrigger

Patch0: grub-2.02-os-alt.patch
Patch1: grub-2.00-sysconfig-path-alt.patch
Patch2: grub-2.02-altlinux-theme.patch
Patch4: grub-2.02-os-alt-xen.patch
Patch5: grub-2.02-debian-disable_floppies.patch
Patch6: grub-2.02-add-fw_path-variable.patch
Patch7: grub-2.02-efibootmgr-check.patch
Patch8: grub-2.02-debian-install_signed.patch
Patch9: grub-2.00-fedora-unrestricted.patch
Patch10: grub2-stfu.patch
Patch11: grub-2.02-shift-interrupt-timeout.patch
Patch12: grub-2.02-ubuntu-efi-setup.patch
Patch13: grub-2.02-check_writes-alt.patch
Patch14: grub-2.02-alt-luks-use-uuid.patch
Patch15: grub-2.02-alt-fedora-linuxefi.patch
Patch16: grub-2.02-suse-fix-build-with-gcc8.patch
Patch17: grub-2.02-fix-binutils-break-grub-efi-build.patch
Patch18: grub-2.02-upstream-default-ptimer.patch
Patch19: grub-2.02-upstream-xfs-sparse-inodes.patch
Patch20: grub-2.02-alt-os-prober-compat.patch
Patch21: grub-2.02-debian-grub-install-extra-removable.patch
Patch22: grub-2.02-debian-grub-install-removable-shim.patch
Patch23: grub-2.02-alt-grub-install-no-fallback-for-removable.patch
Patch24: grub-2.02-alt-update-russian-translation.patch
Patch25: grub-2.02-alt-add-translation-for-installer.patch
Patch26: grub-2.02-alt-grub-install-duplicate-grub-cfg.patch

# add a rhboot/grub-2.02-sb set of patches to ensure SecureBoot safe operation
# refer to url:  https://github.com/rhboot/grub2/commits/grub-2.02-sb
Patch101: grub-2.02-sb-0001-Use-linuxefi-and-initrdefi-where-appropriate.patch
Patch102: grub-2.02-sb-0002-Don-t-allow-insmod-when-secure-boot-is-enabled.patch
Patch103: grub-2.02-sb-0003-Load-arm-with-SB-enabled.patch
Patch104: grub-2.02-sb-0004-Use-linux16-when-appropriate-880840.patch
Patch105: grub-2.02-sb-0005-Make-10_linux-work-with-our-changes-for-linux16-and-.patch
Patch106: grub-2.02-sb-0006-Fix-race-in-EFI-validation.patch
Patch107: grub-2.02-sb-0007-Use-device-part-of-chainloader-target-if-present.patch
Patch108: grub-2.02-sb-0008-Add-secureboot-support-on-efi-chainloader.patch
Patch109: grub-2.02-sb-0009-Make-any-of-the-loaders-that-link-in-efi-mode-honor-.patch
Patch110: grub-2.02-sb-0010-Rework-linux-command.patch
Patch111: grub-2.02-sb-0011-Rework-linux16-command.patch
Patch112: grub-2.02-sb-0012-Re-work-some-intricacies-of-PE-loading.patch
Patch113: grub-2.02-sb-0013-Rework-even-more-of-efi-chainload-so-non-sb-cases-wo.patch
Patch114: grub-2.02-sb-0014-Add-some-grub_dprintf-in-the-linuxefi-path.patch
Patch115: grub-2.02-sb-0015-linuxefi-minor-cleanups.patch
Patch116: grub-2.02-sb-0016-Handle-multi-arch-64-on-32-boot-in-linuxefi-loader.patch
Patch117: grub-2.02-sb-0017-Clean-up-some-errors-in-the-linuxefi-loader.patch

Patch201: grub-2.02-alt-relaxed-kernel-sign-check.patch
Patch202: grub-2.02-fedora-efi-chainloader-truncate-relocation.patch

Patch301: grub-2.06-upstream-font-Fix-an-integer-underflow-in-blit_comb.patch

BuildRequires(pre): rpm-macros-uefi
BuildRequires: flex fonts-bitmap-misc fonts-ttf-dejavu libfreetype-devel python-modules ruby autogen
BuildRequires: liblzma-devel help2man zlib-devel
BuildRequires: libdevmapper-devel
BuildRequires: texinfo
BuildRequires: libfuse-devel

# fonts: choose one

## dejavu
#BuildRequires: fonts-ttf-dejavu
#define font /usr/share/fonts/ttf/dejavu/DejaVuSansMono.ttf

## terminus
#BuildRequires: fonts-bitmap-terminus
#define font /usr/share/fonts/bitmap/terminus/ter-x16n.pcf.gz

## univga
BuildRequires: fonts-bitmap-univga
%define font /usr/share/fonts/bitmap/univga/u_vga16_9.pcf.gz

## see also fonts-bitmap-ucs-miscfixed; efont-unicode doesn't fit

Requires: gettext

# NB: not a fashion but the critical need to fit into 62 sectors
%define _optlevel s

%ifarch %ix86
%global grubefiarch i386-efi
%global linux_module_name linux
%global efi_suff ia32
%endif
%ifarch x86_64
%global grubefiarch x86_64-efi
%global linux_module_name linuxefi
%global efi_suff x64
%endif
%ifarch aarch64
%global grubefiarch arm64-efi
%global linux_module_name linux
%global efi_suff x64
%endif

%package common
Summary: GRand Unified Bootloader (common part)
Group: System/Kernel and hardware
Provides: grub2-common = %EVR
Obsoletes: grub2-common < %EVR

%package pc
Summary: GRand Unified Bootloader (PC BIOS variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release
%ifarch %ix86 x86_64
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif
Provides: grub2-pc = %EVR
Obsoletes: grub2-pc < %EVR

%package ieee1275
Summary: GRand Unified Bootloader (IEEE1275 variant)
Group: System/Kernel and hardware
Requires: %name-common = %version-%release
%ifarch ppc64le
Requires: powerpc-utils
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif

%package efi
Summary: GRand Unified Bootloader (UEFI variant)
Group: System/Kernel and hardware
Requires: %name-common = %EVR
Provides: grub2-efi = %EVR
Obsoletes: grub2-efi < %EVR
Requires(pre): efibootmgr >= 15
%ifarch aarch64
Provides: grub2 = %EVR
Provides: grub = %EVR
%endif

%define desc_generic \
GNU GRUB is a multiboot boot loader. It was derived from GRUB. It is an \
attempt to produce a boot loader for IBM PC-compatible machines that \
has both the ability to be friendly to beginning or otherwise \
nontechnically interested users and the flexibility to help experts in \
diverse environments. It is compatible with Free/Net/OpenBSD and Linux. \
It supports Win 9x/NT and OS/2 via chainloaders. It has a menu \
interface and a command line interface. \
It implements the Multiboot standard, which allows for flexible loading \
of multiple boot images (needed for modular kernels such as the GNU Hurd).

%description
%desc_generic

%description common
%desc_generic

This package carries the shared code and data.

%description pc
%desc_generic

This package provides PC BIOS support.

%description ieee1275
%desc_generic

This package provides Open Firmware (IEEE 1275) support.

%description efi
%desc_generic

This package provides UEFI systems support.

Please note that the official build is signed; this shouldn't
intervene in any way but rather provides means to cope with
UEFI SecureBoot (better described as Restricted Boot) firmware
when one can't disable it easily, doesn't want to, or needs not to.

%prep
%setup -b 5
%patch0 -p2
%patch1 -p1
%patch2 -p2
%patch4 -p2
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p2
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p2
%patch14 -p2
%patch15 -p2
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p2
%patch20 -p2
%patch21 -p1
%patch22 -p1
%patch23 -p2
%patch24 -p2
%patch25 -p2
%patch26 -p2

#SB patches
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p1
%patch105 -p1
%patch106 -p1
%patch107 -p1
%patch108 -p1
%patch109 -p1
%patch110 -p1
%patch111 -p1
%patch112 -p1
%patch113 -p1
%patch114 -p1
%patch115 -p1
%patch116 -p1
%patch117 -p1
%patch201 -p0
%patch202 -p1

%patch301 -p1

sed -i "/^AC_INIT(\[GRUB\]/ s/%version[^]]\+/%version-%release/" configure.ac
sed -i "s/PYTHON:=python/PYTHON:=python3/" autogen.sh

# forced update of translations
rm -rf po/%name.pot

%build
./autogen.sh
build_grub() {
	local dir="$1"; shift
	mkdir -p "$dir"
	pushd "$dir"
	%define _configure_script ../configure
	%configure \
		TARGET_LDFLAGS=-static \
		--disable-werror \
		"$@"
	%make_build
	popd
}

build_efi_image() {
	local mkimage="$1"; shift
	local dir="$1"; shift
	local format="$1"; shift
	"$mkimage" -O "$format" -o "$dir"/grub.efi -d "$dir"/grub-core -p "" \
		part_gpt part_apple part_msdos hfsplus fat ext2 btrfs xfs \
		squash4 normal chain boot configfile diskfilter \
		minicmd reboot halt search search_fs_uuid search_fs_file \
		search_label sleep test syslinuxcfg all_video video font \
		gfxmenu gfxterm gfxterm_background lvm lsefi efifwsetup cat \
		gzio iso9660 loadenv loopback mdraid09 mdraid1x png jpeg \
		extcmd keystatus procfs cryptodisk gcry_rijndael gcry_sha1 \
		gcry_sha256 luks gcry_sha512 gcry_serpent gcry_twofish \
		crypto pbkdf2 password_pbkdf2 echo regexp tftp \
		"$@"
}

%ifarch %ix86 x86_64
build_grub build-pc \
	--with-platform=pc \
#
%endif

%ifarch ppc64le
build_grub build-ieee1275 \
	--with-platform=ieee1275 \
#
%endif

%ifarch %efi_arches
build_grub build-efi \
	--with-platform=efi \
#
build_efi_image build-efi/grub-mkimage build-efi %grubefiarch %linux_module_name

#add forced ia32 version build to be bundled with x86_64 EFI
%ifarch x86_64
build_grub build-efi-ia32 \
	--with-platform=efi \
	--target=i386 \
#
# use 64bit mkimage to build i386-efi image
build_efi_image build-efi/grub-mkimage build-efi-ia32 i386-efi linuxefi
%endif

%if_with sb_kern_signature_check_relaxed
# build grub efi binaries with relaxed kernel signature checks
# (see patch#201).
%ifarch %efi_arches
CFLAGS='%optflags -DRELAX_KERNEL_SIGNATURE_CHECK=1' \
	build_grub build-efi-relaxed \
	--with-platform=efi \
#
build_efi_image build-efi-relaxed/grub-mkimage build-efi-relaxed %grubefiarch %linux_module_name
%endif

%ifarch x86_64
CFLAGS='%optflags -DRELAX_KERNEL_SIGNATURE_CHECK=1' \
	build_grub build-efi-ia32-relaxed \
	--with-platform=efi \
	--target=i386 \
#
# use 64bit mkimage to build i386-efi image
build_efi_image build-efi-relaxed/grub-mkimage build-efi-ia32-relaxed i386-efi linuxefi
%endif
%endif
%endif

%install
%ifarch %ix86 x86_64
%makeinstall_std -C build-pc
%ifarch x86_64
#"cherry pick" only i386 executable
%if_with sb_kern_signature_check_relaxed
install -pDm644 build-efi-ia32/grub.efi %buildroot%_efi_bindir/grubia32sb.efi
install -pDm644 build-efi-ia32-relaxed/grub.efi %buildroot%_efi_bindir/grubia32.efi
%else
install -pDm644 build-efi-ia32/grub.efi %buildroot%_efi_bindir/grubia32.efi
%endif

#install ia32 version in parallel with x64 for x86_64 platforms with ia32 EFI
%makeinstall_std -C build-efi-ia32
%endif
%endif

%makeinstall_std -C \
%ifarch ppc64le
	build-ieee1275
%else
	build-efi
%endif

install -pDm644 %SOURCE1 %buildroot%_sysconfdir/sysconfig/grub2

%find_lang grub

mkdir -p %buildroot/boot/grub/fonts

install -pD -m755 %SOURCE8 %buildroot%_sbindir/
install -pD -m644 %SOURCE9 %buildroot%_man8dir/update-grub.8
install -pD -m644 %SOURCE13 %buildroot%_man8dir/grub-entries.8

# TODO: drop the obsolete one (unifont.pf2)
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/unifont.pf2 %_datadir/fonts/bitmap/misc/8x13.pcf.gz
%buildroot%_bindir/grub-mkfont -o %buildroot/boot/grub/fonts/unicode.pf2 %font

mkdir -p %buildroot/boot/grub/themes

install -pDm755 %SOURCE3 %buildroot%_sysconfdir/grub.d/
sed -i 's,^libdir=,libdir=%_libdir,g' %buildroot%_sysconfdir/grub.d/39_memtest
sed -i 's,@LOCALEDIR@,%_datadir/locale,g' %buildroot%_sysconfdir/grub.d/*

install -pDm755 %SOURCE4  %buildroot%_rpmlibdir/grub.filetrigger
install -pDm755 %SOURCE6  %buildroot%_sbindir/grub-autoupdate
%ifarch %efi_arches
install -pDm755 %SOURCE10 %buildroot%_sbindir/grub-efi-autoupdate
install -pDm755 %SOURCE14 %buildroot%_rpmlibdir/grub-efi.filetrigger
%endif
install -pDm755 %SOURCE12 %buildroot%_sbindir/grub-entries

# Ghost config file
install -d %buildroot/boot/grub
touch %buildroot/boot/grub/grub.cfg
ln -s ../boot/grub/grub.cfg %buildroot%_sysconfdir/grub.cfg

# Docs/habits compat symlink
mkdir -p %buildroot%_sysconfdir/default
ln -s ../sysconfig/grub2 %buildroot%_sysconfdir/default/grub

%ifarch %efi_arches
%if_with sb_kern_signature_check_relaxed
install -pDm644 build-efi/grub.efi %buildroot%_efi_bindir/grub%{efi_suff}sb.efi
install -pDm644 build-efi-relaxed/grub.efi %buildroot%_efi_bindir/grub%{efi_suff}.efi
%else
install -pDm644 build-efi/grub.efi %buildroot%_efi_bindir/grub%{efi_suff}.efi
%endif

# Remove headers
rm -f %buildroot%_libdir/grub-efi/*/*.h
%endif
rm %buildroot%_sysconfdir/grub.d/README
rm %buildroot%_sysconfdir/grub.d/41_custom

%files common -f grub.lang
%dir %_sysconfdir/grub.d
%dir %_libdir/grub
%dir /boot/grub
/boot/grub/*.pf2
/boot/grub/fonts/
/boot/grub/themes/
%_sysconfdir/grub.d/00_header
%_sysconfdir/grub.d/05_altlinux_theme
%_sysconfdir/grub.d/10_linux
%_sysconfdir/grub.d/20_linux_xen
%_sysconfdir/grub.d/30_os-prober
%_sysconfdir/grub.d/30_uefi-firmware
%_sysconfdir/grub.d/39_memtest
%config(noreplace) %_sysconfdir/grub.d/40_custom
%config(noreplace) %_sysconfdir/sysconfig/grub2
%ghost %config(noreplace) /boot/grub/grub.cfg
%_sysconfdir/grub.cfg
%_sysconfdir/default/grub
%_sysconfdir/bash_completion.d/grub
%_rpmlibdir/%name.filetrigger
# these tools are only for efi and x86_64
%ifarch x86_64 ppc64le
%_bindir/grub-render-label
%_sbindir/grub-bios-setup
%_sbindir/grub-macbless
%endif
%_sbindir/grub-install
%_sbindir/grub-mkconfig
%_sbindir/grub-ofpathname
%_sbindir/grub-probe
%_sbindir/grub-reboot
%_sbindir/grub-set-default
%_sbindir/grub-sparc64-setup
%_sbindir/grub-entries
%_sbindir/update-grub
%_bindir/grub-editenv
%_bindir/grub-file
%_bindir/grub-fstest
%_bindir/grub-glue-efi
%_bindir/grub-kbdcomp
%_bindir/grub-menulst2cfg
%_bindir/grub-mknetdir
%_bindir/grub-mkstandalone
%_bindir/grub-mkfont
%_bindir/grub-mklayout
%_bindir/grub-mkimage
%_bindir/grub-mkpasswd-pbkdf2
%_bindir/grub-mkrelpath
%_bindir/grub-mkrescue
%_bindir/grub-mount
%_bindir/grub-script-check
%_bindir/grub-syslinux2cfg
%_datadir/grub/grub-mkconfig_lib
%_man1dir/*
%ifarch x86_64
%exclude %_man1dir/grub-render-label*
%exclude %_man8dir/grub-bios-setup*
%exclude %_man8dir/grub-macbless*
%endif
%_man8dir/*
%_infodir/grub.info.*
%_infodir/grub-dev.info.*

%ifarch %ix86 x86_64
%files pc
%_sbindir/grub-autoupdate
%_libdir/grub/*-pc/
%endif

%ifarch ppc64le
%files ieee1275
%_sbindir/grub-autoupdate
%_libdir/grub/*-ieee1275/
%endif

%ifarch %efi_arches
%files efi
%_efi_bindir/grub%{efi_suff}.efi
%if_with sb_kern_signature_check_relaxed
%_efi_bindir/grub%{efi_suff}sb.efi
%endif
%ifarch x86_64
%_efi_bindir/grubia32.efi
%if_with sb_kern_signature_check_relaxed
%_efi_bindir/grubia32sb.efi
%endif
%_libdir/grub/i386-efi
%endif
%_sbindir/grub-efi-autoupdate
%_libdir/grub/%grubefiarch
%_rpmlibdir/%name-efi.filetrigger
%endif

%ifarch %ix86 x86_64 ppc64le
%ifarch %ix86 x86_64
%post pc
%endif
%ifarch ppc64le
%post ieee1275
%endif
grub-autoupdate || {
	echo "** WARNING: grub-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run it by hand, record the output offline,"
	echo "** WARNING: make sure you have bootable rescue CD/flash media handy"
	echo "** WARNING: and try \`grub-install /dev/sdX' manually"
} >&2
%endif

%post efi
modprobe efivars
grep -q '^GRUB_DISTRIBUTOR=' %_sysconfdir/sysconfig/grub2 ||
	echo 'GRUB_DISTRIBUTOR="ALT Linux"' >> %_sysconfdir/sysconfig/grub2

grep -q '^GRUB_BOOTLOADER_ID=' %_sysconfdir/sysconfig/grub2 ||
	echo 'GRUB_BOOTLOADER_ID="altlinux"' >> %_sysconfdir/sysconfig/grub2

grub-efi-autoupdate || {
	echo "** WARNING: grub-efi-autoupdate failed, NEXT BOOT WILL LIKELY FAIL NOW"
	echo "** WARNING: please run grub-efi-autoupdate by hand, record the output offline,"
	echo "** WARNING: make sure you have e.g. rEFInd bootable media handy."
} >&2

%changelog
