%define major 3.7
Name: ice
Version: %major.1
Release: alt1

Summary: Files common to all Ice packages

License: GPLv2
Group: System/Libraries
Url: http://www.zeroc.com/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# TODO: fix missed /usr
ExcludeArch: aarch64

# Source-url: https://github.com/zeroc-ice/ice/archive/v%version.tar.gz
Source: Ice-%version.tar
Source1: Ice-rpmbuild-%version.tar
Patch1: ice-3.3.1-rh-openssl.patch
Patch2: ice-3.3-alt-build.patch
Patch3: ice-3.3-ssl-krb.patch
Patch4: ice-3.3.1-alt-no-dbl-mv.patch
Patch5: ice-3.3.1-alt-gcc4.6.patch
Patch6: ice-3.3.1-alt-glibc-2.16.patch

%def_without krb

BuildRequires: bzlib-devel gcc-c++ libstdc++-devel libdb4_cxx-devel libexpat-devel libssl-devel python-devel liblmdb-devel
BuildRequires: libmcpp-devel >= 2.7.2

%description
Ice is a modern alternative to object middleware such as CORBA or
COM/DCOM/COM+.  It is easy to learn, yet provides a powerful network
infrastructure for demanding technical applications. It features an
object-oriented specification language, easy to use C++, C#, Java,
Python, Ruby, PHP, and Visual Basic mappings, a highly efficient
protocol, asynchronous method invocation and dispatch, dynamic
transport plug-ins, TCP/IP and UDP/IP support, SSL-based security, a
firewall solution, and much more.

%package -n libice
Summary: The base runtime libraries for Ice applications
Group: System/Libraries
Requires: %name = %version-%release
%if_with krb
BuildRequires: openssl-krb-devel
Requires: openssl-krb
Provides: libice-ssl-krb = %version-%release
%endif

%description -n libice
Ice is a modern alternative to object middleware such as CORBA or
COM/DCOM/COM+.  It is easy to learn, yet provides a powerful network
infrastructure for demanding technical applications. It features an
object-oriented specification language, easy to use C++, C#, Java,
Python, Ruby, PHP, and Visual Basic mappings, a highly efficient
protocol, asynchronous method invocation and dispatch, dynamic
transport plug-ins, TCP/IP and UDP/IP support, SSL-based security, a
firewall solution, and much more.

%package -n libice-devel
Summary: Tools, libraries and headers for developing Ice applications in C++
Group: Development/C++
Requires: %name = %version-%release
Requires: ice-devel-utils = %version-%release
%if_with krb
Requires: libice-ssl-krb = %version
Provides: libice-ssl-krb-devel = %version-%release
%endif

%description -n libice-devel
Tools, libraries and headers for developing Ice applications in C++.

%package devel-utils
Summary: Tools for developing Ice applications
Group: Development/Other
Requires: %name = %version-%release

%description devel-utils
Ice is a modern alternative to object middleware such as CORBA or
COM/DCOM/COM+.  It is easy to learn, yet provides a powerful network
infrastructure for demanding technical applications. It features an
object-oriented specification language, easy to use C++, C#, Java,
Python, Ruby, PHP, and Visual Basic mappings, a highly efficient
protocol, asynchronous method invocation and dispatch, dynamic
transport plug-ins, TCP/IP and UDP/IP support, SSL-based security, a
firewall solution, and much more.

%package utils
Summary: Ice utilities and admin tools.
Group: System/Configuration/Other
Requires: %name = %version-%release

%description utils
Admin tools to manage Ice servers (IceGrid, IceStorm, IceBox etc.),
plus various Ice-related utilities.

%package servers
Summary: Ice servers and related files.
Group: System/Servers
Requires: ice-utils = %version-%release
#Requires(pre): shadow-utils
# Requirements for the init.d services
#Requires(post): /sbin/chkconfig
#Requires(preun): /sbin/chkconfig
#Requires(preun): /sbin/service

%description servers
Ice servers: glacier2router, icebox, icegridnode, icegridregistry, 
icebox, iceboxnet, icepatch2server and related files.

%prep
%setup -a1 -n Ice-%version

sed -i 's|-Werror||' config/Make.rules.Linux
#sed -i 's|\(\$(CPPFLAGS)\)|\1 -g -fpermissive|g' \
#	$(find ./ -name Makefile) config/Make.rules

%build
%make_build -C cpp OPTIMIZE=yes CONFIGS=cpp11-shared embedded_runpath_prefix="" DB_HOME=%prefix

%install
%make_install -C cpp prefix=%buildroot embedded_runpath_prefix="" install

#
# move installed files
#
## dirs
mkdir -p %buildroot/%_prefix
mkdir -p %buildroot%_datadir/Ice-%version
## bins
mv %buildroot/bin %buildroot/%_bindir
## clean libs
#mv %buildroot/lib/ImportKey.class %buildroot%_datadir/Ice-%version
## libs
mv %buildroot/%_lib %buildroot%_libdir
## includes
mv %buildroot/include %buildroot%_includedir
# man
#mv %buildroot/man %buildroot%_datadir
## slices
#mv %buildroot/slice %buildroot%_datadir/Ice-%version
## scripts
# TODO
test -d %buildroot/config && mv %buildroot/config/* %buildroot%_datadir/Ice-%version

rm -rf %buildroot/doc %buildroot/ICE_LICENSE %buildroot/LICENSE
rm -f %buildroot%_libdir/libIceStormService.so

#
# Certificates
#
cp -r certs %buildroot%_datadir/Ice-%version

#
# Config files (for build another parts)
#
mkdir -p %buildroot%_datadir/Ice-%version/config
cp config/Make.rules.Linux %buildroot%_datadir/Ice-%version/config
cp config/Make.rules %buildroot%_datadir/Ice-%version/config
cp config/PropertyNames.xml %buildroot%_datadir/Ice-%version/config
#cp config/IceDevKey.snk %buildroot%_datadir/Ice-%version/config

#
# initrd files (for servers)
#
mkdir -p %buildroot%_sysconfdir
cp Ice-rpmbuild-%version/*.conf %buildroot%_sysconfdir
mkdir -p %buildroot%_initrddir
for i in icegridregistry icegridnode glacier2router
do
    cp Ice-rpmbuild-%version/$i.%_vendor %buildroot%_initrddir/$i
done

%files
%doc ICE_LICENSE LICENSE Ice-rpmbuild-%version/THIRD_PARTY_LICENSE.Linux Ice-rpmbuild-%version/SOURCES.Linux Ice-rpmbuild-%version/README.Linux-RPM
%dir %_datadir/Ice-%version
#%_datadir/Ice-%version/slice
%_datadir/Ice-%version/certs
%_datadir/Ice-%version/config

%files -n libice
#_libdir/libFreeze.so.*
%_libdir/libGlacier2.so.*
%_libdir/libIceBox.so.*
%_libdir/libIcePatch2.so.*
%_libdir/libIce.so.*
%_libdir/libIceDB.so.*
%_libdir/libIceSSL.so.*
%_libdir/libIceStorm.so.*
%_libdir/libIceDiscovery.so.*
%_libdir/libIceLocatorDiscovery.so.*
%_libdir/libGlacier2CryptPermissionsVerifier.so.*
#_libdir/libIceUtil.so.*
#_libdir/libSlice.so.*
%_libdir/libIceXML.so.*
%_libdir/libIceGrid.so.*

%files -n libice-devel
%_includedir/*
#_libdir/libFreeze.so
%_libdir/libGlacier2.so
%_libdir/libIceBox.so
%_libdir/libIceGrid.so
%_libdir/libIcePatch2.so
%_libdir/libIce.so
#_libdir/libIceDB.so
%_libdir/libIceSSL.so
%_libdir/libIceStorm.so
%_libdir/libIceDiscovery.so
%_libdir/libIceLocatorDiscovery.so
#_libdir/libIceUtil.so
#_libdir/libIceXML.so
#_libdir/libSlice.so

%files devel-utils
%_bindir/slice2*

%files utils
#_bindir/dumpdb
#_bindir/transformdb
%_bindir/iceboxadmin
%_bindir/icebridge
%_bindir/icegriddb
%_bindir/icestormdb
%_bindir/icepatch2calc
%_bindir/icepatch2client
%_bindir/icestormadmin
%_bindir/icegridadmin
#_man1dir/*
#_bindir/iceca
#_datadir/Ice-%version/ImportKey.class
#attr(755,root,root) %_datadir/Ice-%version/convertssl.py*

%files servers
%_libdir/libIceStormService.so.*
%_bindir/glacier2router
%_bindir/icebox
%_bindir/icegridnode
%_bindir/icegridregistry
%_bindir/icepatch2server
#_bindir/icestormmigrate
# TODO
#_datadir/Ice-%version/templates.xml
#attr(755,root,root) %_datadir/Ice-%version/upgradeicegrid.py*
#_datadir/Ice-%version/icegrid-slice.3.*.ice.gz
%_initrddir/icegridregistry
%_initrddir/icegridnode
%_initrddir/glacier2router
%config(noreplace) %_sysconfdir/icegridregistry.conf
%config(noreplace) %_sysconfdir/icegridnode.conf
%config(noreplace) %_sysconfdir/glacier2router.conf

%pre servers
getent group ice > /dev/null || groupadd -r ice
getent passwd ice > /dev/null || \
       useradd -r -g ice -d %_localstatedir/ice \
       -s /sbin/nologin -c "Ice Service account" ice
test -d %_localstatedir/ice/icegrid/registry || \
       mkdir -p %_localstatedir/ice/icegrid/registry; chown -R ice.ice %_localstatedir/ice
test -d %_localstatedir/ice/icegrid/node1 || \
       mkdir -p %_localstatedir/ice/icegrid/node1; chown -R ice.ice %_localstatedir/ice
exit 0

%post servers
/sbin/chkconfig --add icegridregistry
/sbin/chkconfig --add icegridnode
/sbin/chkconfig --add glacier2router

%preun servers
if [ $1 = 0 ]; then
        /sbin/service icegridnode stop >/dev/null 2>&1 || :
        /sbin/chkconfig --del icegridnode
        /sbin/service icegridregistry stop >/dev/null 2>&1 || :
        /sbin/chkconfig --del icegridregistry
        /sbin/service glacier2router stop >/dev/null 2>&1 || :
        /sbin/chkconfig --del glacier2router
fi

%postun servers
if [ "$1" -ge "1" ]; then
        /sbin/service icegridnode condrestart >/dev/null 2>&1 || :
        /sbin/service icegridregistry condrestart >/dev/null 2>&1 || :
        /sbin/service glacier2router condrestart >/dev/null 2>&1 || :
fi


%changelog
