%def_disable snapshot
%define real_ver_major 69
%define real_ver_minor 1
%define real_ver %{real_ver_major}.%{real_ver_minor}
%define rname icu

%def_without doc

#%%ifarch aarch64 ppc64le
#%%def_disable check
#%%endif

Name: icu69
Version: %(echo %real_ver_major | sed -e 's|\(.\)|\1.|').%real_ver_minor
Release: alt0.p9.1
Epoch: 1

Summary: International Components for Unicode
Group: System/Libraries
License: ICU and BSD-3-Clause and Unicode-TOU and naist-2003
Url: http://www.icu-project.org/

%if_disabled snapshot
Source: https://github.com/unicode-org/%rname/releases/download/release-%{real_ver_major}-%{real_ver_minor}/icu4c-%{real_ver_major}_%{real_ver_minor}-src.tgz
%else
Vcs: https://github.com/unicode-org/icu.git
Source: icu-%version.tar
%endif
Patch: icu-6.3.1-alt-e2k.patch
# https://github.com/unicode-org/icu/pull/1715
# https://github.com/unicode-org/icu/commit/29f1188d191a7a75ac7ffa4bfa390f625da39c53.patch
Patch1: icu-69.1-Fix_undefined_behaviour_in_ComplexUnitsConverter.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ libstdc++-devel python3-base
%{?_with_doc:BuildRequires: doxygen}

%define libicu libicu%real_ver_major

%filter_from_requires /pkgconfig(/d
%filter_from_provides /pkgconfig(/d

%description
ICU is a C++ and C library that provides robust and full-featured Unicode
support

%package utils
Summary: International Components for Unicode (utilities)
Group: Text tools
Requires: %libicu = %EVR
Conflicts: icu-utils

%description utils
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the utilites for compiling and developing
programs with ICU

%package -n %libicu
Summary: International Components for Unicode (libraries)
Group: System/Libraries

%description -n %libicu
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the runtime libraries for ICU

%package -n libicu69-devel
Summary: International Components for Unicode (development files)
Group: Development/C++
Requires: %libicu = %EVR
Requires: icu69-utils = %EVR
Conflicts: libicu-devel

%description -n libicu69-devel
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains the development files for ICU

%package samples
Summary: Sample programs for ICU
Group: Development/Other
Requires: libicu69-devel = %EVR
BuildArch: noarch
Conflicts: icu-samples

%description samples
ICU is a C++ and C library that provides robust and full-featured Unicode
support. This package contains sample code for ICU

%prep
%setup -c
%setup -DT -n %name-%version/icu
%ifarch %e2k
%patch -p2
%add_optflags -finput-charset=utf8
%endif
%patch1 -p2

sed -ri '/^LDFLAGSICUDT=/ s,-nodefaultlibs -nostdlib,,' source/config/mh-linux

%build
export PYTHON=%__python3
%add_optflags %(getconf LFS_CFLAGS)
cd source
%autoreconf
%configure \
	--disable-samples \
	--disable-static \
	--with-data-packaging=library
%make_build

%install
cd source
%makeinstall_std
cp -a samples %buildroot%_datadir/icu
# Return define TRUE and FALSE for old software
subst 's/^Cflags: /Cflags: -DU_DEFINE_FALSE_AND_TRUE=1/' %buildroot%_pkgconfigdir/*.pc

%check
cd source
%make check

%files -n %libicu
%_libdir/*.so.*
%doc LICENSE readme.html

%changelog
