Name: imlib2
Version: 1.5.1
Release: alt1

Summary: Image loading, saving, rendering, and manipulation library
License: Imlib2
Group: System/Libraries
Url: http://docs.enlightenment.org/api/imlib2/html/
# http://download.sourceforge.net/enlightenment/%name-%version.tar.bz2
Source: %name-%version.tar

%def_disable static
%def_enable mmx

# Automatically added by buildreq on Sun Sep 16 2012
# optimized out: gnu-config libX11-devel pkg-config xorg-xextproto-devel xorg-xproto-devel zlib-devel
BuildRequires: bzlib-devel libXext-devel libfreetype-devel libgif-devel libjpeg-devel libpng-devel libtiff-devel

%description
Imlib 2 is a library that does image file loading and saving as well as
rendering, manipulation, arbitrary polygon support, etc.  It does ALL of
these operations FAST.  Imlib2 also tries to be highly intelligent about
doing them, so writing naive programs can be done easily, without
sacrificing speed.  This is a complete rewrite over the Imlib 1.x
series.  The architecture is more modular, simple, and flexible.

%package devel
Summary: Imlib2 development files
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains development files for Imlib2.

%package devel-static
Summary: Imlib static libraries
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
Imlib2 static libraries.

%package utils
Summary: Imlib2 image manipulation and testing utilities.
Group: Graphics
Requires: %name = %version-%release

%description utils
Imlib2 is an advanced replacement library for libraries like libXpm
that provides many more features with much greater flexibility and
speed than standard libraries, including font rasterization, rotation,
RGBA space rendering and blending, dynamic binary filters, scripting,
and more.

This package provides some test programs and utilities from Imlib2
distribution.

%prep
%setup
sed -i 's/echo \$libdirs -lImlib2 @my_libs@/echo -lImlib2/' imlib2-config.in

%build
%configure \
	%{subst_enable static} \
%ifarch x86_64
	--enable-amd64 \
%endif
%ifarch %ix86
	%{subst_enable mmx} \
%endif
	--enable-visibility-hiding

%make_build

%install
%makeinstall_std

# remove non-packaged files
find %buildroot%_libdir/ -name '*.la' -delete

%files
%_libdir/*.so.*
%dir %_libdir/%name/
%dir %_libdir/%name/filters/
%dir %_libdir/%name/loaders/
%_libdir/%name/filters/*.so
%_libdir/%name/loaders/*.so

%files devel
%_bindir/%name-config
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*
%doc doc/{*gif,*.html}

%files utils
%_bindir/*
%_datadir/%name/
%exclude %_bindir/%name-config

%if_enabled static
%files devel-static
%_libdir/lib*.a
%_libdir/%name/*/*.a
%endif

%changelog
