%def_with libatm
%def_with selinux

Name: iproute2
Version: 5.3.0
Release: alt1

Summary: Advanced IP routing and network devices configuration tools
License: GPLv2+
Group: Networking/Other
Url: http://www.linuxfoundation.org/collaborate/workgroups/networking/iproute2
# git://git.altlinux.org/gears/i/%name.git
Source: %name-%version-%release.tar

Requires: libnetlink = %version-%release
Provides: iproute = %version-%release
Obsoletes: iproute < %version

# Automatically added by buildreq on Mon Jan 07 2019
BuildRequires: flex libcap-devel libdb4-devel libelf-devel libiptables-devel libmnl-devel
%{?_with_libatm:BuildRequires: libatm-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}

%description
The iproute package contains networking utilities (ip and rtmon, for
example) which are designed to use the advanced networking capabilities
of the Linux 2.4.x and 2.6.x kernel.

%package doc
Summary: Documentation for Advanced IP routing and network device configuration tools
Group: Networking/Other
BuildArch: noarch

%description doc
Documentation for iproute2.

%package -n arpd
Summary: The arpd daemon
Group: Networking/Other
Requires: %name = %version-%release

%description -n arpd
arpd is a daemon collecting gratuitous ARP information, saving it on
local disk and feeding it to kernel on demand to avoid redundant
broadcasting due to limited size of kernel ARP cache.

%package -n libnetlink
Summary: Netlink socket library
Group: System/Libraries

%description -n libnetlink
This package contains libnetlink dynamic library.

%package -n libnetlink-devel
Summary: Netlink socket library headers
Group: System/Libraries
Requires: libnetlink = %version-%release

%description -n libnetlink-devel
This package contains libnetlink dynamic library headers.

%prep
%setup -n %name-%version-%release

%build
%make_build DBM_INCLUDE=%_includedir/db4 LIBDIR=%_libdir CCOPTS='%optflags' V=1

%install
%makeinstall_std LIBDIR=%_libdir
cp -a doc/actions README* %buildroot%_docdir/%name/
mkdir -p %buildroot{%_bindir,%_sbindir,%_localstatedir/arpd}
pushd %buildroot/sbin
rm rtpr
mv arpd bridge ctstat genl ifstat lnstat nstat routef routel rtacct rtstat ss tipc \
	%buildroot%_sbindir/
popd

# libnetlink
mkdir -p %buildroot{%_includedir,%_libdir,%_man3dir,/%_lib}
install -p -m644 lib/libnetlink.so %buildroot/%_lib
install -p -m644 include/{libnetlink.h,ll_map.h} %buildroot%_includedir
install -p -m644 man/man3/libnetlink.3 %buildroot%_man3dir/
ln -rs %buildroot/%_lib/libnetlink.so %buildroot%_libdir/

# symlinks for unprivileged users
for prg in ip rtmon tc; do
	ln -rs %buildroot/sbin/$prg %buildroot%_bindir/
done
for prg in lnstat nstat routel ss; do
	ln -rs %buildroot%_sbindir/$prg %buildroot%_bindir/
done

%define _unpackaged_files_terminate_build 1

%files
/sbin/*
%_sbindir/*
%_bindir/*
%_libdir/tc/
%exclude %_sbindir/arpd
%config(noreplace) %_sysconfdir/%name
%_man7dir/*
%_man8dir/*
%_datadir/bash-completion/completions/tc

%files doc
%_docdir/%name/

%files -n arpd
%_sbindir/arpd
%attr(700,root,root) %dir %_localstatedir/arpd

%files -n libnetlink
/%_lib/libnetlink.so

%files -n libnetlink-devel
%_includedir/*
%_libdir/libnetlink.so
%_man3dir/*

%changelog
