Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          jaxb2-common-basics
Version:       0.9.5
Release:       alt1_5jpp8
Summary:       JAXB2 Basics
License:       BSD
Url:           https://github.com/highsource/jaxb2-basics
Source0:       https://github.com/highsource/jaxb2-basics/archive/%{version}.tar.gz

BuildRequires: maven-local
BuildRequires: mvn(com.google.code.javaparser:javaparser)
BuildRequires: mvn(com.vividsolutions:jts)
BuildRequires: mvn(commons-beanutils:commons-beanutils)
BuildRequires: mvn(commons-io:commons-io)
BuildRequires: mvn(javax.xml.bind:jaxb-api)
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(org.apache.ant:ant)
BuildRequires: mvn(org.apache.ant:ant-launcher)
BuildRequires: mvn(org.apache.commons:commons-lang3)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires: mvn(org.glassfish.jaxb:jaxb-runtime)
BuildRequires: mvn(org.glassfish.jaxb:jaxb-xjc)
BuildRequires: mvn(org.jvnet.jaxb2.maven2:maven-jaxb22-plugin)
BuildRequires: mvn(org.jvnet.jaxb2.maven2:maven-jaxb2-plugin-testing)
BuildRequires: mvn(org.slf4j:jcl-over-slf4j)
BuildRequires: mvn(org.slf4j:slf4j-api)
BuildRequires: mvn(org.sonatype.oss:oss-parent:pom:)
BuildRequires: mvn(org.springframework:spring-context-support)
BuildRequires: mvn(xmlunit:xmlunit)

BuildArch:     noarch
Source44: import.info

%description
JAXB2 Basics is a part of JAXB2 Commons project which
implements plugins and tools for JAXB 2.x reference
implementation.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q -n jaxb2-basics-%{version}
# Cleanup
find -name "*.bat" -print -delete
find -name "*.class" -print -delete
find -name "*.jar" -print -delete

%pom_remove_plugin :maven-source-plugin
%pom_remove_plugin :maven-deploy-plugin plugins
%pom_remove_plugin :maven-shade-plugin plugins
%pom_disable_module dist
%pom_disable_module samples
%pom_disable_module tests

%pom_change_dep :ant-optional org.apache.ant:ant
%pom_change_dep -r org.springframework:spring org.springframework:spring-context-support
# rm -rf tools/src/main/java/org/jvnet/jaxb2_commons/plugin/spring
%pom_change_dep :maven-jaxb2-plugin :maven-jaxb22-plugin

%pom_xpath_set "pom:dependency[pom:artifactId = 'tools' ]/pom:groupId" com.sun
%pom_xpath_remove "pom:dependency[pom:artifactId = 'tools' ]/pom:scope"
%pom_xpath_remove "pom:dependency[pom:artifactId = 'tools' ]/pom:systemPath"

%pom_xpath_set "pom:plugin[pom:groupId = 'org.jvnet.jaxb2.maven2' ]/pom:artifactId" maven-jaxb22-plugin

%build

%mvn_build

%install
%mvn_install

%files -f .mfiles
%doc README.md TODO.md
%doc --no-dereference LICENSE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE

%changelog
